package com.turbospaces.boot;

import java.net.URI;
import java.util.HashSet;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.ZookeeperServiceInfo;

public class ServiceInfoTest {
    @Test
    public void kafka() throws Exception {
        PlainServiceInfo info = new PlainServiceInfo( "kafka", "kafka://node1:9092" );
        Assertions.assertTrue( info.getHost().contains( "node1" ) );
        Assertions.assertEquals( 9092, info.getPort() );
    }
    @Test
    public void zk() throws Exception {
        ZookeeperServiceInfo info = new ZookeeperServiceInfo( "zookeeper", new URI( "zk://node1,node2,node3:2181" ) );
        HashSet<String> brokers = new HashSet<>( info.getNodes() );
        Assertions.assertTrue( brokers.contains( "node1" ) );
        Assertions.assertTrue( brokers.contains( "node2" ) );
        Assertions.assertTrue( brokers.contains( "node3" ) );
        Assertions.assertEquals( 2181, info.getPort() );
    }
}
