package com.turbospaces.di;

import java.util.Objects;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.google.inject.AbstractModule;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;

public abstract class AbstractBootstrapAwareModule extends AbstractModule implements BootstrapAware {
    protected final Logger logger = LoggerFactory.getLogger( getClass() );
    protected Bootstrap bootstrap;

    @Override
    public void setBootstrap(Bootstrap bootstrap) throws Exception {
        this.bootstrap = Objects.requireNonNull( bootstrap );
    }
    @Override
    public Bootstrap getBootstrap() {
        return bootstrap;
    }
    @Override
    protected void configure() {
        requestInjection( this );
    }
}
