/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.replication;

import com.turbospaces.replication.ReplicationRecord;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public interface Replicator {
    public String getNamespace();

    public void addDetachedEvent(String var1, byte[] var2);

    public static abstract class Utils {
        public static byte[] encode(ReplicationRecord record) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream io = new ObjectOutputStream(baos);){
                io.writeShort(1);
                record.writeExternal(io);
                io.flush();
                byte[] byArray = baos.toByteArray();
                return byArray;
            }
        }

        public static ReplicationRecord decode(byte[] data) throws IOException, ClassNotFoundException {
            try (ByteArrayInputStream baos = new ByteArrayInputStream(data);
                 ObjectInputStream io = new ObjectInputStream(baos);){
                short version = io.readShort();
                switch (version) {
                    case 1: {
                        ReplicationRecord record = new ReplicationRecord();
                        record.readExternal(io);
                        ReplicationRecord replicationRecord = record;
                        return replicationRecord;
                    }
                }
                throw new IOException("unknown version " + version);
            }
        }

        private Utils() {
        }
    }
}

