/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

public abstract class DelegatingCompletionStage<T>
implements CompletionStage<T> {
    private Bootstrap bootstrap;
    private CompletableFuture<T> future;

    public DelegatingCompletionStage(Bootstrap bootstrap, CompletableFuture<T> future) {
        this.bootstrap = Objects.requireNonNull(bootstrap);
        this.future = Objects.requireNonNull(future);
    }

    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        this.setBootstrap(fn);
        return this.future.thenApply(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        this.setBootstrap(fn);
        return this.future.thenApplyAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        this.setBootstrap(fn);
        return this.future.thenApplyAsync(fn, executor);
    }

    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        this.setBootstrap(action);
        return this.future.thenAccept((Consumer)action);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        this.setBootstrap(action);
        return this.future.thenAcceptAsync((Consumer)action);
    }

    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        this.setBootstrap(action);
        return this.future.thenAcceptAsync((Consumer)action, executor);
    }

    public CompletableFuture<Void> thenRun(Runnable action) {
        this.setBootstrap(action);
        return this.future.thenRun(action);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        this.setBootstrap(action);
        return this.future.thenRunAsync(action);
    }

    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        this.setBootstrap(action);
        return this.future.thenRunAsync(action, executor);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        this.setBootstrap(fn);
        return this.future.thenCombine(other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        this.setBootstrap(fn);
        return this.future.thenCombineAsync(other, fn);
    }

    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        this.setBootstrap(fn);
        return this.future.thenCombineAsync(other, fn, executor);
    }

    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        this.setBootstrap(action);
        return this.future.thenAcceptBoth(other, (BiConsumer)action);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        this.setBootstrap(action);
        return this.future.thenAcceptBothAsync(other, (BiConsumer)action);
    }

    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        this.setBootstrap(action);
        return this.future.thenAcceptBothAsync(other, (BiConsumer)action, executor);
    }

    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        this.setBootstrap(action);
        return this.future.runAfterBoth((CompletionStage)other, action);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        this.setBootstrap(action);
        return this.future.runAfterBothAsync((CompletionStage)other, action);
    }

    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        this.setBootstrap(action);
        return this.future.runAfterBothAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        this.setBootstrap(fn);
        return this.future.applyToEither((CompletionStage)other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        this.setBootstrap(fn);
        return this.future.applyToEitherAsync((CompletionStage)other, fn);
    }

    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        this.setBootstrap(fn);
        return this.future.applyToEitherAsync((CompletionStage)other, fn, executor);
    }

    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        this.setBootstrap(action);
        return this.future.acceptEither((CompletionStage)other, (Consumer)action);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        this.setBootstrap(action);
        return this.future.acceptEitherAsync((CompletionStage)other, (Consumer)action);
    }

    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        this.setBootstrap(action);
        return this.future.acceptEitherAsync((CompletionStage)other, (Consumer)action, executor);
    }

    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        this.setBootstrap(action);
        return this.future.runAfterEither((CompletionStage)other, action);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        this.setBootstrap(action);
        return this.future.runAfterEitherAsync((CompletionStage)other, action);
    }

    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        this.setBootstrap(action);
        return this.future.runAfterEitherAsync((CompletionStage)other, action, executor);
    }

    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        this.setBootstrap(fn);
        return this.future.thenCompose(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        this.setBootstrap(fn);
        return this.future.thenComposeAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        this.setBootstrap(fn);
        return this.future.thenComposeAsync(fn, executor);
    }

    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        this.setBootstrap(action);
        return this.future.whenComplete(action);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        this.setBootstrap(action);
        return this.future.whenCompleteAsync(action);
    }

    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        this.setBootstrap(action);
        return this.future.whenCompleteAsync(action, executor);
    }

    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        this.setBootstrap(fn);
        return this.future.handle(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        this.setBootstrap(fn);
        return this.future.handleAsync(fn);
    }

    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        this.setBootstrap(fn);
        return this.future.handleAsync(fn, executor);
    }

    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return this.future.toCompletableFuture();
    }

    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        this.setBootstrap(fn);
        return this.future.exceptionally(fn);
    }

    private void setBootstrap(BiFunction fn) {
        if (fn instanceof BootstrapAware) {
            try {
                ((BootstrapAware)((Object)fn)).setBootstrap(this.bootstrap);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }
    }

    private void setBootstrap(Function fn) {
        if (fn instanceof BootstrapAware) {
            try {
                ((BootstrapAware)((Object)fn)).setBootstrap(this.bootstrap);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }
    }

    private void setBootstrap(BiConsumer action) {
        if (action instanceof BootstrapAware) {
            try {
                ((BootstrapAware)((Object)action)).setBootstrap(this.bootstrap);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }
    }

    private void setBootstrap(Consumer action) {
        if (action instanceof BootstrapAware) {
            try {
                ((BootstrapAware)((Object)action)).setBootstrap(this.bootstrap);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }
    }

    private void setBootstrap(Runnable action) {
        if (action instanceof BootstrapAware) {
            try {
                ((BootstrapAware)((Object)action)).setBootstrap(this.bootstrap);
            }
            catch (Exception err) {
                throw new RuntimeException(err);
            }
        }
    }
}

