/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Slf4jReporter;
import com.codahale.metrics.health.HealthCheck;
import com.codahale.metrics.health.HealthCheckRegistry;
import com.codahale.metrics.health.HealthCheckRegistryListener;
import com.codahale.metrics.jmx.JmxReporter;
import com.codahale.metrics.jvm.ThreadDump;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.Uninterruptibles;
import com.google.inject.Injector;
import com.netflix.archaius.api.Config;
import com.netflix.archaius.config.PollingDynamicConfig;
import com.turbospaces.boot.ApplicationStatus;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;
import com.turbospaces.boot.BootstrapPlugin;
import com.turbospaces.boot.Channel;
import com.turbospaces.boot.DisposableHealtchCheck;
import com.turbospaces.boot.FixedSizePlatform;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.di.DiEngine;
import com.turbospaces.di.PostConstructable;
import com.turbospaces.di.PreDestroyable;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.UPSs;
import io.jaegertracing.Configuration;
import io.jaegertracing.internal.JaegerTracer;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.jvm.JvmMemoryMetrics;
import io.micrometer.core.instrument.binder.system.UptimeMetrics;
import io.micrometer.core.instrument.composite.CompositeMeterRegistry;
import io.micrometer.core.instrument.dropwizard.DropwizardConfig;
import io.micrometer.core.instrument.dropwizard.DropwizardMeterRegistry;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import io.micrometer.elastic.ElasticConfig;
import io.micrometer.elastic.ElasticMeterRegistry;
import io.opentracing.Tracer;
import io.sentry.SentryClient;
import io.sentry.SentryClientFactory;
import io.sentry.connection.EventSendCallback;
import io.sentry.event.Event;
import io.sentry.event.helper.ShouldSendEventCallback;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.Cloud;
import org.springframework.cloud.ConfigurableCloudConnector;
import org.springframework.cloud.ConfigurableCloudFactory;
import org.springframework.cloud.app.ApplicationInstanceInfo;
import org.springframework.cloud.service.UriBasedServiceInfo;

public abstract class AbstractBootstrap
implements Bootstrap,
ShouldSendEventCallback {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final MetricRegistry metricRegistry = new MetricRegistry();
    private final CompositeMeterRegistry meterRegistry = Metrics.globalRegistry;
    private final Set<Channel> channels = new LinkedHashSet<Channel>();
    private final Set<BootstrapPlugin> plugins = new LinkedHashSet<BootstrapPlugin>();
    private final JmxReporter jmxReporter;
    private final HealthCheckRegistry healthCheckRegistry;
    private final Thread shutdownHook;
    private final String release;
    private final Cloud cloud;
    private final ApplicationProperties props;
    private final FixedSizePlatform platform;
    private final SentryClient sentry;
    private final JaegerTracer tracer;
    private KeyStore keyStore;
    private ApplicationStatus status = ApplicationStatus.UNKNOWN;
    private Injector parent;
    private DiEngine diEngine;
    private Date started;

    protected AbstractBootstrap(final ApplicationProperties props) throws Throwable {
        this.props = Objects.requireNonNull(props);
        this.keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ConfigurableCloudConnector connector = new ConfigurableCloudConnector(props, this.keyStore);
        ApplicationInstanceInfo info = connector.getApplicationInstanceInfo();
        Map cloudProps = info.getProperties();
        String space = cloudProps.get("cloud.application.space_name").toString();
        String host = cloudProps.get("cloud.application.host").toString();
        String slot = cloudProps.get("cloud.application.instance_index").toString();
        String service = info.getAppId();
        this.release = PlatformUtil.version(props.CLOUD_APP_NAME);
        Optional sentryOpt = UPSs.findServiceInfoByName(connector, "sentry");
        if (sentryOpt.isPresent()) {
            UriBasedServiceInfo serviceInfo = (UriBasedServiceInfo)sentryOpt.get();
            this.sentry = SentryClientFactory.sentryClient((String)serviceInfo.getUri());
        } else {
            this.sentry = SentryClientFactory.sentryClient();
        }
        this.sentry.setEnvironment(space);
        this.sentry.setRelease(this.release);
        this.sentry.setServerName(service + "/" + slot);
        this.sentry.addShouldSendEventCallback((ShouldSendEventCallback)this);
        this.sentry.addEventSendCallback(new EventSendCallback(){

            public void onSuccess(Event event) {
                Counter counter = AbstractBootstrap.this.metricRegistry.counter(MetricRegistry.name((String)"sentry", (String[])new String[]{"success"}));
                counter.inc();
            }

            public void onFailure(Event event, Exception exception) {
                Counter counter = AbstractBootstrap.this.metricRegistry.counter(MetricRegistry.name((String)"sentry", (String[])new String[]{"failure"}));
                counter.inc();
            }
        });
        this.cloud = new ConfigurableCloudFactory(connector, this).getCloud();
        ImmutableMap.Builder tracingTags = ImmutableMap.builder();
        tracingTags.put((Object)"ip", (Object)PlatformUtil.detectIp());
        tracingTags.put((Object)"hostname", (Object)host);
        tracingTags.put((Object)"cloud.application.instance_index", (Object)slot);
        Configuration fromEnv = Configuration.fromEnv((String)service).withTracerTags((Map)tracingTags.build());
        this.tracer = fromEnv.getTracer();
        ImmutableList.Builder meterTags = ImmutableList.builder();
        meterTags.add((Object)Tag.of((String)"env", (String)space));
        meterTags.add((Object)Tag.of((String)"release", (String)this.release));
        meterTags.add((Object)Tag.of((String)"service", (String)service));
        this.meterRegistry.config().commonTags((Iterable)meterTags.build());
        this.meterRegistry.add((MeterRegistry)new DropwizardMeterRegistry(new DropwizardConfig(){

            public String prefix() {
                return "boot";
            }

            public String get(String key) {
                return props.cfg().getString(key, null);
            }
        }, this.metricRegistry, HierarchicalNameMapper.DEFAULT, Clock.SYSTEM){

            protected Double nullGaugeValue() {
                return Double.NaN;
            }
        });
        Optional opt = UPSs.findServiceInfoByName(this, "elastic-search");
        if (opt.isPresent()) {
            final PlainServiceInfo si = (PlainServiceInfo)((Object)opt.get());
            this.meterRegistry.add((MeterRegistry)new ElasticMeterRegistry(new ElasticConfig(){

                public String host() {
                    return String.format("%s://%s:%d", si.getScheme(), si.getHost(), si.getPort());
                }

                public String userName() {
                    return si.getUserName();
                }

                public String password() {
                    return si.getPassword();
                }

                public String get(String k) {
                    return props.cfg().getString(k, null);
                }

                public Duration connectTimeout() {
                    return Duration.ofSeconds(((Integer)props.TCP_CONNECTION_TIMEOUT.get()).intValue());
                }

                public Duration readTimeout() {
                    return Duration.ofSeconds(((Integer)props.TCP_SOCKET_TIMEOUT.get()).intValue());
                }
            }, Clock.SYSTEM));
        }
        JvmMemoryMetrics jvmMetrics = new JvmMemoryMetrics();
        jvmMetrics.bindTo((MeterRegistry)this.meterRegistry);
        UptimeMetrics uptimeMetrics = new UptimeMetrics();
        uptimeMetrics.bindTo((MeterRegistry)this.meterRegistry);
        this.jmxReporter = JmxReporter.forRegistry((MetricRegistry)this.metricRegistry).inDomain((String)props.APP_JMX_DOMAIN.get()).build();
        this.platform = new FixedSizePlatform(props, (MeterRegistry)this.meterRegistry);
        this.shutdownHook = new Thread(new Runnable(){

            @Override
            public void run() {
                AbstractBootstrap.this.logger.info("running shutdown hook now ...");
                try {
                    AbstractBootstrap.this.shutdown();
                }
                catch (Throwable err) {
                    AbstractBootstrap.this.logger.error(err.getMessage(), err);
                }
            }
        });
        this.healthCheckRegistry = new HealthCheckRegistry();
        this.healthCheckRegistry.addListener(new HealthCheckRegistryListener(){

            public void onHealthCheckAdded(String name, HealthCheck healthCheck) {
                if (healthCheck instanceof BootstrapAware) {
                    try {
                        ((BootstrapAware)healthCheck).setBootstrap(AbstractBootstrap.this);
                    }
                    catch (Exception err) {
                        ExceptionUtils.wrapAndThrow((Throwable)err);
                    }
                }
                if (AbstractBootstrap.this.parent != null) {
                    AbstractBootstrap.this.parent.injectMembers((Object)healthCheck);
                }
            }

            public void onHealthCheckRemoved(String name, HealthCheck healthCheck) {
                if (healthCheck instanceof DisposableHealtchCheck) {
                    DisposableHealtchCheck preDestoy = (DisposableHealtchCheck)healthCheck;
                    try {
                        preDestoy.preDestroy();
                    }
                    catch (Exception err) {
                        AbstractBootstrap.this.logger.error(err.getMessage(), (Throwable)err);
                    }
                }
            }
        });
    }

    @Override
    public final void start(DiEngine engine) throws Throwable {
        block24: {
            boolean isHealthy = true;
            HashSet<String> unhealthy = new HashSet<String>();
            Lock rwLock = this.lock.writeLock();
            rwLock.lock();
            try {
                this.status = ApplicationStatus.STARTING;
                this.diEngine = engine;
                if (((Boolean)this.props.APP_WAIT_FOR_HEALTHCHECKS_ENABLED.get()).booleanValue()) {
                    this.logger.debug("about to run health-checks now ...");
                    int it = 0;
                    long now = System.currentTimeMillis();
                    long timeout = TimeUnit.SECONDS.toMillis(((Integer)this.props.APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT.get()).intValue());
                    isHealthy = false;
                    while (System.currentTimeMillis() - now <= timeout) {
                        boolean tmp = true;
                        ++it;
                        unhealthy.clear();
                        for (Map.Entry entry : this.healthCheckRegistry().runHealthChecks().entrySet()) {
                            this.logger.debug("iteration({}) ::: healthcheck({}) - isHealthy({})", new Object[]{it, entry.getKey(), ((HealthCheck.Result)entry.getValue()).isHealthy()});
                            tmp &= ((HealthCheck.Result)entry.getValue()).isHealthy();
                            if (((HealthCheck.Result)entry.getValue()).isHealthy()) continue;
                            unhealthy.add((String)entry.getKey());
                        }
                        if (tmp) {
                            isHealthy = true;
                            break;
                        }
                        int waitSec = (Integer)this.props.APP_WAIT_FOR_HEALTHCHECKS_INTERVAL.get();
                        this.logger.debug("about to wait {} sec before next health_check attempt ...", (Object)waitSec);
                        Uninterruptibles.sleepUninterruptibly((long)waitSec, (TimeUnit)TimeUnit.SECONDS);
                    }
                }
                if (isHealthy) {
                    long now = System.currentTimeMillis();
                    this.logger.debug("about to perform actual application start ...");
                    this.doStart();
                    this.logger.info("application started in={} sec ...", (Object)TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - now));
                    this.started = new Date();
                    this.status = ApplicationStatus.RUNNING;
                    if (((Boolean)this.props.APP_SHUTDOWN_HOOK_ENABLED.get()).booleanValue()) {
                        this.logger.info("shutdown hook has been registered ...");
                        Runtime.getRuntime().addShutdownHook(this.shutdownHook);
                    }
                    break block24;
                }
                this.logger.info("app will not start due to failed healch_checks ...");
                this.removeAllHealthChecks();
                if (this.platform != null) {
                    this.platform.preDestroy();
                }
                throw new Throwable("unhealthy = " + ((Object)unhealthy).toString());
            }
            catch (Throwable err) {
                boolean removed;
                if (isHealthy) {
                    this.logger.error(err.getMessage(), err);
                }
                if (removed = Runtime.getRuntime().removeShutdownHook(this.shutdownHook)) {
                    this.logger.info("removed shutdown hook ...");
                }
                if (isHealthy) {
                    this.logger.error("application failed to start, stopping lifecycle thread ...");
                    try {
                        this.shutdown();
                    }
                    catch (Throwable t) {
                        this.logger.warn(t.getMessage(), t);
                    }
                }
                this.logger.info("dumping all threads now before termination ... ");
                ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
                ThreadDump dump = new ThreadDump(threadMXBean);
                dump.dump((OutputStream)System.err);
                if (!this.isDevMode()) {
                    try (Slf4jReporter reporter = Slf4jReporter.forRegistry((MetricRegistry)this.metricRegistry).scheduleOn((ScheduledExecutorService)this.platform.executor()).build();){
                        reporter.report();
                    }
                }
                throw err;
            }
            finally {
                rwLock.unlock();
            }
        }
    }

    @Override
    public final void shutdown() throws Throwable {
        Lock rwLock = this.lock.writeLock();
        rwLock.lock();
        try {
            this.status = ApplicationStatus.STOPPING;
            this.doStop();
        }
        finally {
            this.status = ApplicationStatus.STOPPED;
            rwLock.unlock();
        }
    }

    @Override
    public ApplicationStatus status() {
        Lock rLock = this.lock.readLock();
        rLock.lock();
        try {
            ApplicationStatus applicationStatus = this.status;
            return applicationStatus;
        }
        finally {
            rLock.unlock();
        }
    }

    @Override
    public DiEngine diEngine() {
        return Objects.requireNonNull(this.diEngine, "'bootstrap.diEngine' is not started yet");
    }

    @Override
    public FixedSizePlatform platform() {
        return this.platform;
    }

    @Override
    public MetricRegistry metricRegistry() {
        return this.metricRegistry;
    }

    @Override
    public MeterRegistry meterRegisry() {
        return this.meterRegistry;
    }

    @Override
    public HealthCheckRegistry healthCheckRegistry() {
        return this.healthCheckRegistry;
    }

    @Override
    public Cloud cloud() {
        return this.cloud;
    }

    @Override
    public KeyStore keyStore() {
        return this.keyStore;
    }

    @Override
    public ApplicationProperties props() {
        return this.props;
    }

    @Override
    public String release() {
        return this.release;
    }

    @Override
    public boolean isDevMode() {
        return (Boolean)this.props.APP_DEV_MODE.get();
    }

    @Override
    public int port() {
        return (Integer)this.props.CLOUD_APP_PORT.get();
    }

    @Override
    public String spaceName() {
        return (String)this.props.CLOUD_APP_SPACE_NAME.get();
    }

    @Override
    public String appId() {
        return (String)this.props.CLOUD_APP_ID.get();
    }

    @Override
    public boolean addChannel(Channel acceptor) {
        if (this.status().isRunning()) {
            return false;
        }
        return this.channels.add(acceptor);
    }

    @Override
    public boolean isHealthy() {
        SortedMap results = this.healthCheckRegistry.runHealthChecks();
        return results.isEmpty();
    }

    @Override
    public void registerHealthCheck(String name, HealthCheck check) {
        this.healthCheckRegistry().register(name, check);
    }

    @Override
    public boolean addPlugin(BootstrapPlugin plugin) {
        if (this.status().isRunning()) {
            return false;
        }
        return this.plugins.add(plugin);
    }

    @Override
    public SentryClient sentry() {
        return this.sentry;
    }

    @Override
    public Tracer tracer() {
        return this.tracer;
    }

    @Override
    public Collection<BootstrapPlugin> plugins() {
        return Collections.unmodifiableCollection(this.plugins);
    }

    @Override
    public Collection<Channel> channels() {
        return Collections.unmodifiableCollection(this.channels);
    }

    @Override
    public Date startedAt() {
        return this.started;
    }

    public boolean shouldSend(Event event) {
        return (Boolean)this.props.APP_SENTRY_ENABLED.get();
    }

    protected void doStart() throws Throwable {
        this.jmxReporter.start();
        for (BootstrapPlugin plugin : this.plugins) {
            if (!(plugin instanceof BootstrapAware)) continue;
            ((BootstrapAware)((Object)plugin)).setBootstrap(this);
        }
        this.parent = this.diEngine.configure(this);
        for (BootstrapPlugin plugin : this.plugins) {
            if (!(plugin instanceof PostConstructable)) continue;
            this.logger.debug("post-construct plugin '{}'", (Object)plugin);
            ((PostConstructable)((Object)plugin)).postConstruct();
        }
        for (Channel acceptor : this.channels) {
            this.parent.injectMembers((Object)acceptor);
        }
        this.diEngine.up();
        this.beforeAccept();
        for (Channel acceptor : this.channels) {
            acceptor.accept();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStop() throws Throwable {
        this.removeAllHealthChecks();
        for (Channel acceptor : this.channels) {
            try {
                this.logger.info("disposing acceptor {} ...", (Object)acceptor);
                acceptor.dispose();
            }
            catch (Throwable t) {
                this.logger.warn(t.getMessage(), t);
            }
        }
        try {
            if (this.diEngine != null) {
                this.logger.info("closing application now ...");
                this.diEngine.down();
            }
        }
        catch (Throwable throwable) {
            for (BootstrapPlugin plugin : this.plugins) {
                if (!(plugin instanceof PreDestroyable)) continue;
                this.logger.debug("pre-destroy plugin '{}'", (Object)plugin);
                try {
                    ((PreDestroyable)((Object)plugin)).preDestroy();
                }
                catch (Throwable err) {
                    this.logger.error(err.getMessage(), err);
                }
            }
            this.logger.info("stoppping JMX reporter ...");
            this.jmxReporter.close();
            this.logger.info("shutting down platform now ...");
            this.platform.preDestroy();
            if (this.sentry != null) {
                this.logger.info("closing sentry now ...");
                this.sentry.closeConnection();
            }
            if (((Boolean)this.props.APP_CLEAR_CFG_AT_SHUTDOWN_ENABLED.get()).booleanValue()) {
                this.logger.debug("disposing CFG ...");
                ApplicationConfig cfg = this.props.cfg();
                for (String next : cfg.getConfigNames()) {
                    Config removed = cfg.removeConfig(next);
                    if (!(removed instanceof PollingDynamicConfig)) continue;
                    PollingDynamicConfig pdc = (PollingDynamicConfig)removed;
                    pdc.shutdown();
                }
                cfg.shutdown();
            }
            throw throwable;
        }
        for (BootstrapPlugin plugin : this.plugins) {
            if (!(plugin instanceof PreDestroyable)) continue;
            this.logger.debug("pre-destroy plugin '{}'", (Object)plugin);
            try {
                ((PreDestroyable)((Object)plugin)).preDestroy();
            }
            catch (Throwable err) {
                this.logger.error(err.getMessage(), err);
            }
        }
        this.logger.info("stoppping JMX reporter ...");
        this.jmxReporter.close();
        this.logger.info("shutting down platform now ...");
        this.platform.preDestroy();
        if (this.sentry != null) {
            this.logger.info("closing sentry now ...");
            this.sentry.closeConnection();
        }
        if (((Boolean)this.props.APP_CLEAR_CFG_AT_SHUTDOWN_ENABLED.get()).booleanValue()) {
            this.logger.debug("disposing CFG ...");
            ApplicationConfig cfg = this.props.cfg();
            for (String next : cfg.getConfigNames()) {
                Config removed = cfg.removeConfig(next);
                if (!(removed instanceof PollingDynamicConfig)) continue;
                PollingDynamicConfig pdc = (PollingDynamicConfig)removed;
                pdc.shutdown();
            }
            cfg.shutdown();
        }
    }

    protected void beforeAccept() throws Exception {
    }

    private void removeAllHealthChecks() {
        for (String name : this.healthCheckRegistry.getNames()) {
            this.logger.info("removing health-check {} ...", (Object)name);
            this.healthCheckRegistry.unregister(name);
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

