/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.turbospaces.boot.FixedSizePlatform;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.common.ThrowableAction;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.simple.SimpleMeterRegistry;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apache.commons.lang3.mutable.MutableInt;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlatformTest {
    @Test
    public void takeUntil() {
        List<String> list = Arrays.asList("1", "2", "3");
        Stream stream = list.stream();
        final MutableInt count = new MutableInt();
        PlatformUtil.takeWhile(stream, (Predicate)new Predicate<String>(){

            @Override
            public boolean test(String t) {
                count.increment();
                return count.intValue() < 2;
            }
        }).count();
        Assert.assertEquals((long)2L, (long)count.intValue());
    }

    @Test
    public void works() throws Exception {
        final Logger logger = LoggerFactory.getLogger(this.getClass());
        ApplicationConfig cfg = ApplicationConfig.create();
        cfg.setLocalProperty("app.platform.graceful-shutdown-timeout", (Object)1);
        SimpleMeterRegistry registry = new SimpleMeterRegistry();
        FixedSizePlatform platform = new FixedSizePlatform(new ApplicationProperties(cfg), (MeterRegistry)registry);
        final CountDownLatch semaphore = new CountDownLatch(1);
        final CountDownLatch l = new CountDownLatch(1);
        final CountDownLatch interrupted = new CountDownLatch(1);
        platform.work(new ThrowableAction(){

            public void apply() throws Exception {
                semaphore.await();
                l.countDown();
            }
        });
        platform.execute(new Runnable(){

            @Override
            public void run() {
                semaphore.countDown();
            }
        });
        l.await();
        final CountDownLatch started = new CountDownLatch(1);
        platform.work(new ThrowableAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void apply() {
                4 var1_1 = this;
                synchronized (var1_1) {
                    try {
                        logger.debug("about to hang forever ...");
                        Thread.sleep(1000L);
                        logger.debug("count down to mark started ...");
                        started.countDown();
                        this.wait();
                    }
                    catch (InterruptedException err) {
                        interrupted.countDown();
                    }
                }
            }
        });
        started.await();
        platform.preDestroy();
        interrupted.await();
    }
}

