package com.turbospaces.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;

import org.apache.commons.lang3.RandomStringUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.netflix.archaius.api.exceptions.ConfigException;
import com.turbospaces.boot.FixedSizePlatform;
import com.turbospaces.boot.Platform;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;

import io.micrometer.core.instrument.simple.SimpleMeterRegistry;

public class CompletableRequestReplyMapperTest {
    Logger logger = LoggerFactory.getLogger( getClass() );
    Platform platform;
    CompletableRequestReplyMapper<String, Long> mapper;

    @Before
    public void before() throws ConfigException {
        ApplicationProperties props = new ApplicationProperties( ApplicationConfig.create() );
        platform = new FixedSizePlatform( props, new SimpleMeterRegistry() );
        mapper = new CompletableRequestReplyMapper<>();
    }
    @After
    public void after() throws Exception {
        platform.preDestroy();
    }
    @Test
    public void works() throws InterruptedException {
        String key = RandomStringUtils.randomAlphanumeric( 4 );
        CountDownLatch l = new CountDownLatch( 1 );
        CompletableFuture<Long> f = mapper.acquire( key, 15, TimeUnit.SECONDS );
        f.whenCompleteAsync( new BiConsumer<Long, Throwable>() {
            @Override
            public void accept(Long value, Throwable t) {
                if ( value != null ) {
                    l.countDown();
                }
            }
        }, platform );
        Assert.assertEquals( 1, mapper.pendingCount() );
        mapper.onComplete( key, System.currentTimeMillis() );
        l.await();
        Assert.assertEquals( 0, mapper.pendingCount() );
    }
    @Test
    public void timeout() throws InterruptedException {
        String key = RandomStringUtils.randomAlphanumeric( 4 );
        CountDownLatch l = new CountDownLatch( 1 );
        CompletableFuture<Long> f = mapper.acquire( key, 1, TimeUnit.SECONDS );
        f.whenCompleteAsync( new BiConsumer<Long, Throwable>() {
            @Override
            public void accept(Long value, Throwable t) {
                if ( t != null ) {
                    logger.error( t.getMessage(), t );
                    l.countDown();
                }
            }
        }, platform );
        l.await();
        Thread.sleep( 100 ); // wait due to asynchronous cleanup
        Assert.assertEquals( 0, mapper.pendingCount() );
    }
}
