package com.turbospaces.boot;

import java.net.URI;
import java.util.HashSet;

import org.junit.Assert;
import org.junit.Test;

import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.ZookeeperServiceInfo;

public class ServiceInfoTest {
    @Test
    public void kafka() throws Exception {
        PlainServiceInfo info = new PlainServiceInfo( "kafka", "kafka://node1:9092" );
        Assert.assertTrue( info.getHost().contains( "node1" ) );
        Assert.assertEquals( 9092, info.getPort() );
    }
    @Test
    public void zk() throws Exception {
        ZookeeperServiceInfo info = new ZookeeperServiceInfo( "zookeeper", new URI( "zk://node1,node2,node3:2181" ) );
        HashSet<String> brokers = new HashSet<>( info.getNodes() );
        Assert.assertTrue( brokers.contains( "node1" ) );
        Assert.assertTrue( brokers.contains( "node2" ) );
        Assert.assertTrue( brokers.contains( "node3" ) );
        Assert.assertEquals( 2181, info.getPort() );
    }
}
