package com.turbospaces.ups;

import org.springframework.cloud.service.ServiceInfo.ServiceLabel;
import org.springframework.cloud.service.common.RelationalServiceInfo;

@ServiceLabel("h2")
public class H2DatabaseServiceInfo extends RelationalServiceInfo {
    public static final String HSQL_SCHEME = "h2";

    public H2DatabaseServiceInfo(String id, String uri) {
        super( id, uri, null, HSQL_SCHEME );
    }
    @Override
    protected String buildJdbcUrl() {
        return String.format( "jdbc:%s", getUriInfo().toString().replace( "//", "" ) );
    }
}
