package com.turbospaces.replication;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public interface Replicator {
    String getNamespace();
    void addDetachedEvent(String eventId, byte[] payload);

    public abstract static class Utils {
        public static byte[] encode(final ReplicationRecord record) throws IOException {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (ObjectOutputStream io = new ObjectOutputStream( baos )) {
                io.writeShort( 1 );
                record.writeExternal( io );
                io.flush();
                return baos.toByteArray();
            }
        }
        public static ReplicationRecord decode(final byte[] data) throws IOException, ClassNotFoundException {
            try (ByteArrayInputStream baos = new ByteArrayInputStream( data )) {
                try (ObjectInputStream io = new ObjectInputStream( baos )) {
                    short version = io.readShort();
                    switch ( version ) {
                        case 1: {
                            ReplicationRecord record = new ReplicationRecord();
                            record.readExternal( io );
                            return record;
                        }
                        default:
                            throw new IOException( "unknown version " + version );
                    }
                }
            }
        }
        private Utils() {}
    }
}
