package com.turbospaces.replication;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ReplicationRecord implements Externalizable {
    private long idx;
    private String eventId;
    private long createdAt, updatedAt;
    private int retryAttempt;
    private byte[] payload;

    public ReplicationRecord() {}
    public ReplicationRecord(ReplicationRecord old) {
        setIdx( old.getIdx() );
        setEventId( old.getEventId() );
        setCreatedAt( old.getCreatedAt() );
        setUpdatedAt( old.getUpdatedAt() );
        setRetryAttempt( old.getRetryAttempt() );
        setPayload( old.getPayload() );
    }
    public long getIdx() {
        return idx;
    }
    public void setIdx(long idx) {
        this.idx = idx;
    }
    public String getEventId() {
        return eventId;
    }
    public void setEventId(String eventId) {
        this.eventId = eventId;
    }
    public long getCreatedAt() {
        return createdAt;
    }
    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }
    public long getUpdatedAt() {
        return updatedAt;
    }
    public void setUpdatedAt(long updatedAt) {
        this.updatedAt = updatedAt;
    }
    public int getRetryAttempt() {
        return retryAttempt;
    }
    public void setRetryAttempt(int retryAttempt) {
        this.retryAttempt = retryAttempt;
    }
    public byte[] getPayload() {
        return payload;
    }
    public void setPayload(byte[] payload) {
        this.payload = payload;
    }
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeLong( idx );
        out.writeUTF( eventId );
        out.writeLong( createdAt );
        out.writeLong( updatedAt );
        out.writeInt( retryAttempt );
        out.writeInt( payload.length );
        out.write( payload );
    }
    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        idx = in.readLong();
        eventId = in.readUTF();
        createdAt = in.readLong();
        updatedAt = in.readLong();
        retryAttempt = in.readInt();
        payload = new byte[in.readInt()];
        in.read( payload );
    }
}
