package com.turbospaces.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public interface RequestReplyMapper<K, V> {
    CompletableFuture<V> acquire(K corrId, int timeout, TimeUnit unit);
    void onComplete(K corrId, V value);
    void onError(K corrId, Throwable reason);
    void clear();
    int pendingCount();
}
