package com.turbospaces.common;

import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;

import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.BootstrapAware;

public abstract class DelegatingCompletionStage<T> implements CompletionStage<T> {
    private Bootstrap bootstrap;
    private CompletableFuture<T> future;

    public DelegatingCompletionStage(Bootstrap bootstrap, CompletableFuture<T> future) {
        this.bootstrap = Objects.requireNonNull( bootstrap );
        this.future = Objects.requireNonNull( future );
    }
    @Override
    public <U> CompletableFuture<U> thenApply(Function<? super T, ? extends U> fn) {
        setBootstrap( fn );
        return future.thenApply( fn );
    }
    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn) {
        setBootstrap( fn );
        return future.thenApplyAsync( fn );
    }
    @Override
    public <U> CompletableFuture<U> thenApplyAsync(Function<? super T, ? extends U> fn, Executor executor) {
        setBootstrap( fn );
        return future.thenApplyAsync( fn, executor );
    }
    @Override
    public CompletableFuture<Void> thenAccept(Consumer<? super T> action) {
        setBootstrap( action );
        return future.thenAccept( action );
    }
    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action) {
        setBootstrap( action );
        return future.thenAcceptAsync( action );
    }
    @Override
    public CompletableFuture<Void> thenAcceptAsync(Consumer<? super T> action, Executor executor) {
        setBootstrap( action );
        return future.thenAcceptAsync( action, executor );
    }
    @Override
    public CompletableFuture<Void> thenRun(Runnable action) {
        setBootstrap( action );
        return future.thenRun( action );
    }
    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action) {
        setBootstrap( action );
        return future.thenRunAsync( action );
    }
    @Override
    public CompletableFuture<Void> thenRunAsync(Runnable action, Executor executor) {
        setBootstrap( action );
        return future.thenRunAsync( action, executor );
    }
    @Override
    public <U, V> CompletableFuture<V> thenCombine(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        setBootstrap( fn );
        return future.thenCombine( other, fn );
    }
    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn) {
        setBootstrap( fn );
        return future.thenCombineAsync( other, fn );
    }
    @Override
    public <U, V> CompletableFuture<V> thenCombineAsync(CompletionStage<? extends U> other, BiFunction<? super T, ? super U, ? extends V> fn, Executor executor) {
        setBootstrap( fn );
        return future.thenCombineAsync( other, fn, executor );
    }
    @Override
    public <U> CompletableFuture<Void> thenAcceptBoth(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        setBootstrap( action );
        return future.thenAcceptBoth( other, action );
    }
    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action) {
        setBootstrap( action );
        return future.thenAcceptBothAsync( other, action );
    }
    @Override
    public <U> CompletableFuture<Void> thenAcceptBothAsync(CompletionStage<? extends U> other, BiConsumer<? super T, ? super U> action, Executor executor) {
        setBootstrap( action );
        return future.thenAcceptBothAsync( other, action, executor );
    }
    @Override
    public CompletableFuture<Void> runAfterBoth(CompletionStage<?> other, Runnable action) {
        setBootstrap( action );
        return future.runAfterBoth( other, action );
    }
    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action) {
        setBootstrap( action );
        return future.runAfterBothAsync( other, action );
    }
    @Override
    public CompletableFuture<Void> runAfterBothAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        setBootstrap( action );
        return future.runAfterBothAsync( other, action, executor );
    }
    @Override
    public <U> CompletableFuture<U> applyToEither(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        setBootstrap( fn );
        return future.applyToEither( other, fn );
    }
    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn) {
        setBootstrap( fn );
        return future.applyToEitherAsync( other, fn );
    }
    @Override
    public <U> CompletableFuture<U> applyToEitherAsync(CompletionStage<? extends T> other, Function<? super T, U> fn, Executor executor) {
        setBootstrap( fn );
        return future.applyToEitherAsync( other, fn, executor );
    }
    @Override
    public CompletableFuture<Void> acceptEither(CompletionStage<? extends T> other, Consumer<? super T> action) {
        setBootstrap( action );
        return future.acceptEither( other, action );
    }
    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action) {
        setBootstrap( action );
        return future.acceptEitherAsync( other, action );
    }
    @Override
    public CompletableFuture<Void> acceptEitherAsync(CompletionStage<? extends T> other, Consumer<? super T> action, Executor executor) {
        setBootstrap( action );
        return future.acceptEitherAsync( other, action, executor );
    }
    @Override
    public CompletableFuture<Void> runAfterEither(CompletionStage<?> other, Runnable action) {
        setBootstrap( action );
        return future.runAfterEither( other, action );
    }
    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action) {
        setBootstrap( action );
        return future.runAfterEitherAsync( other, action );
    }
    @Override
    public CompletableFuture<Void> runAfterEitherAsync(CompletionStage<?> other, Runnable action, Executor executor) {
        setBootstrap( action );
        return future.runAfterEitherAsync( other, action, executor );
    }
    @Override
    public <U> CompletableFuture<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> fn) {
        setBootstrap( fn );
        return future.thenCompose( fn );
    }
    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn) {
        setBootstrap( fn );
        return future.thenComposeAsync( fn );
    }
    @Override
    public <U> CompletableFuture<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> fn, Executor executor) {
        setBootstrap( fn );
        return future.thenComposeAsync( fn, executor );
    }
    @Override
    public CompletableFuture<T> whenComplete(BiConsumer<? super T, ? super Throwable> action) {
        setBootstrap( action );
        return future.whenComplete( action );
    }
    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action) {
        setBootstrap( action );
        return future.whenCompleteAsync( action );
    }
    @Override
    public CompletableFuture<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> action, Executor executor) {
        setBootstrap( action );
        return future.whenCompleteAsync( action, executor );
    }
    @Override
    public <U> CompletableFuture<U> handle(BiFunction<? super T, Throwable, ? extends U> fn) {
        setBootstrap( fn );
        return future.handle( fn );
    }
    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn) {
        setBootstrap( fn );
        return future.handleAsync( fn );
    }
    @Override
    public <U> CompletableFuture<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> fn, Executor executor) {
        setBootstrap( fn );
        return future.handleAsync( fn, executor );
    }
    @Override
    public CompletableFuture<T> toCompletableFuture() {
        return future.toCompletableFuture();
    }
    @Override
    public CompletableFuture<T> exceptionally(Function<Throwable, ? extends T> fn) {
        setBootstrap( fn );
        return future.exceptionally( fn );
    }
    @SuppressWarnings("rawtypes")
    private void setBootstrap(BiFunction fn) {
        if ( fn instanceof BootstrapAware ) {
            try {
                ( (BootstrapAware) fn ).setBootstrap( bootstrap );
            }
            catch ( Exception err ) {
                throw new RuntimeException( err );
            }
        }
    }
    @SuppressWarnings("rawtypes")
    private void setBootstrap(Function fn) {
        if ( fn instanceof BootstrapAware ) {
            try {
                ( (BootstrapAware) fn ).setBootstrap( bootstrap );
            }
            catch ( Exception err ) {
                throw new RuntimeException( err );
            }
        }
    }
    @SuppressWarnings("rawtypes")
    private void setBootstrap(BiConsumer action) {
        if ( action instanceof BootstrapAware ) {
            try {
                ( (BootstrapAware) action ).setBootstrap( bootstrap );
            }
            catch ( Exception err ) {
                throw new RuntimeException( err );
            }
        }
    }
    @SuppressWarnings("rawtypes")
    private void setBootstrap(Consumer action) {
        if ( action instanceof BootstrapAware ) {
            try {
                ( (BootstrapAware) action ).setBootstrap( bootstrap );
            }
            catch ( Exception err ) {
                throw new RuntimeException( err );
            }
        }
    }
    private void setBootstrap(Runnable action) {
        if ( action instanceof BootstrapAware ) {
            try {
                ( (BootstrapAware) action ).setBootstrap( bootstrap );
            }
            catch ( Exception err ) {
                throw new RuntimeException( err );
            }
        }
    }
}
