package com.turbospaces.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RequestReplyFuture<T> extends CompletableFuture<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger( RequestReplyFuture.class );

    private final Object key;
    private ScheduledFuture<?> timeoutTask;

    public RequestReplyFuture(Object key, ScheduledFuture<?> timeoutTask) {
        this.key = key;
        this.timeoutTask = timeoutTask;
    }
    @Override
    public boolean complete(T value) {
        boolean toReturn = super.complete( value );

        if ( timeoutTask != null ) {
            if ( timeoutTask.isCancelled() ) {

            }
            else {
                LOGGER.trace( "about to cancel timeout task for key: {}", key );
                timeoutTask.cancel( false );
                timeoutTask = null;
            }
        }

        return toReturn;
    }
    @Override
    public boolean completeExceptionally(Throwable ex) {
        boolean toReturn = super.completeExceptionally( ex );
        timeoutTask = null;
        return toReturn;
    }
}
