/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.rpc;

import api.v1.ApiFactory;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.turbospaces.api.facade.HeadersFacade;
import com.turbospaces.api.facade.RequestWrapperFacade;
import com.turbospaces.api.facade.ResponseStatusFacade;
import com.turbospaces.api.facade.ResponseWrapperFacade;
import com.turbospaces.boot.Bootstrap;
import com.turbospaces.boot.MockCloud;
import com.turbospaces.boot.SimpleBootstrap;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.ApplicationProperties;
import com.turbospaces.dispatch.EmbeddedTransactionalRequest;
import com.turbospaces.dispatch.SafeRequestHandler;
import com.turbospaces.dispatch.TransactionalRequest;
import com.turbospaces.dispatch.TransactionalRequestHandler;
import com.turbospaces.dispatch.TransactionalRequestOutcome;
import com.turbospaces.dispatch.WorkerCompletableTask;
import com.turbospaces.executor.WorkUnit;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Timer;
import io.micrometer.core.instrument.search.RequiredSearch;
import io.opentracing.Span;
import io.opentracing.noop.NoopSpan;
import io.vavr.CheckedRunnable;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.RandomStringUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SafeRequestHandlerTest {
    private static final Logger log = LoggerFactory.getLogger(SafeRequestHandlerTest.class);
    CountDownLatch latch = new CountDownLatch(1);
    String key = RandomStringUtils.randomAlphanumeric((int)4);
    WorkUnit unit = new WorkUnit(){

        public String topic() {
            return "junit";
        }

        public long timestamp() {
            return System.currentTimeMillis();
        }

        public byte[] key() {
            return SafeRequestHandlerTest.this.key.getBytes();
        }
    };

    SafeRequestHandlerTest() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void works() throws Throwable {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            ApiFactory apiFactory = (ApiFactory)Mockito.mock(ApiFactory.class);
            HeadersFacade headersw = (HeadersFacade)Mockito.mock(HeadersFacade.class);
            Mockito.when((Object)headersw.getMessageId()).thenReturn((Object)UUID.randomUUID().toString());
            ResponseStatusFacade statusw = (ResponseStatusFacade)Mockito.mock(ResponseStatusFacade.class);
            Mockito.when((Object)statusw.isOK()).thenReturn((Object)true);
            ResponseWrapperFacade respw = (ResponseWrapperFacade)Mockito.mock(ResponseWrapperFacade.class);
            Mockito.when((Object)respw.status()).thenReturn((Object)statusw);
            RequestWrapperFacade reqw = (RequestWrapperFacade)Mockito.mock(RequestWrapperFacade.class);
            Mockito.when((Object)reqw.headers()).thenReturn((Object)headersw);
            Mockito.when((Object)reqw.body()).thenReturn((Object)Any.pack((Message)req));
            Mockito.when((Object)reqw.toReply((Message)ArgumentMatchers.any())).thenReturn((Object)respw);
            final Semaphore semaphore = new Semaphore(0);
            final CheckedRunnable task1 = (CheckedRunnable)Mockito.mock(CheckedRunnable.class);
            final CheckedRunnable task2 = (CheckedRunnable)Mockito.mock(CheckedRunnable.class);
            SafeRequestHandler handler = new SafeRequestHandler(reqw, apiFactory, (Span)NoopSpan.INSTANCE, this.unit, (TransactionalRequest)new EmbeddedTransactionalRequest(Timestamp.class, (Message.Builder)Timestamp.newBuilder(), this.unit, reqw, this.latch), (TransactionalRequestHandler)new TransactionalRequestHandler<Timestamp, Timestamp.Builder>(){

                public boolean actorIsRequired() {
                    return false;
                }

                public boolean isImmediateAcknowledge() {
                    return false;
                }

                public void apply(TransactionalRequest<Timestamp, Timestamp.Builder> cmd) throws Exception {
                    cmd.addMetricTag("provider", Long.toString(System.currentTimeMillis()));
                    cmd.replyWhen(boot.globalPlatform().submit(() -> {
                        semaphore.acquire();
                        task1.run();
                    }));
                    cmd.replyWhen(boot.globalPlatform().submit(() -> {
                        semaphore.acquire();
                        task2.run();
                    }));
                }
            });
            handler.setBootstrap((Bootstrap)boot);
            WorkerCompletableTask task = handler.get();
            handler.run();
            ((CheckedRunnable)Mockito.verify((Object)task1, (VerificationMode)Mockito.never())).run();
            ((CheckedRunnable)Mockito.verify((Object)task2, (VerificationMode)Mockito.never())).run();
            semaphore.release(2);
            TransactionalRequestOutcome operationOutcome = task.get();
            ((CheckedRunnable)Mockito.verify((Object)task1)).run();
            ((CheckedRunnable)Mockito.verify((Object)task2)).run();
            RequiredSearch search = boot.meterRegistry().get("dispatcher");
            Timer timer = search.timer();
            Measurement next = (Measurement)timer.measure().iterator().next();
            log.info(next.toString());
            Assertions.assertTrue((boolean)operationOutcome.getNotifications().isEmpty());
            Assertions.assertTrue((boolean)operationOutcome.getEventStream().isEmpty());
        }
        finally {
            boot.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void applicationExceptionInMain() throws Exception {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            ApiFactory apiFactory = (ApiFactory)Mockito.mock(ApiFactory.class);
            HeadersFacade headersw = (HeadersFacade)Mockito.mock(HeadersFacade.class);
            Mockito.when((Object)headersw.getMessageId()).thenReturn((Object)UUID.randomUUID().toString());
            ResponseStatusFacade statusw = (ResponseStatusFacade)Mockito.mock(ResponseStatusFacade.class);
            Mockito.when((Object)statusw.isNotFound()).thenReturn((Object)true);
            ResponseWrapperFacade respw = (ResponseWrapperFacade)Mockito.mock(ResponseWrapperFacade.class);
            Mockito.when((Object)respw.status()).thenReturn((Object)statusw);
            RequestWrapperFacade reqw = (RequestWrapperFacade)Mockito.mock(RequestWrapperFacade.class);
            Mockito.when((Object)reqw.headers()).thenReturn((Object)headersw);
            Mockito.when((Object)reqw.body()).thenReturn((Object)Any.pack((Message)req));
            Mockito.when((Object)reqw.toExceptionalReply((Message)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any())).thenReturn((Object)respw);
            SafeRequestHandler handler = new SafeRequestHandler(reqw, apiFactory, (Span)NoopSpan.INSTANCE, this.unit, (TransactionalRequest)new EmbeddedTransactionalRequest(Timestamp.class, (Message.Builder)Timestamp.newBuilder(), this.unit, reqw, this.latch), (TransactionalRequestHandler)new TransactionalRequestHandler<Timestamp, Timestamp.Builder>(){

                public boolean actorIsRequired() {
                    return false;
                }

                public boolean isImmediateAcknowledge() {
                    return false;
                }

                public void apply(TransactionalRequest<Timestamp, Timestamp.Builder> cmd) throws Exception {
                    throw new IllegalArgumentException();
                }
            });
            handler.setBootstrap((Bootstrap)boot);
            WorkerCompletableTask task = handler.get();
            handler.run();
            TransactionalRequestOutcome operationOutcome = task.get();
            RequiredSearch search = boot.meterRegistry().get("dispatcher");
            Timer timer = search.timer();
            Measurement next = (Measurement)timer.measure().iterator().next();
            log.info(next.toString());
            Assertions.assertTrue((boolean)operationOutcome.getReply().status().isNotFound());
        }
        finally {
            boot.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void exceptionInReplyWhen() throws Exception {
        ApplicationConfig cfg = MockCloud.newMock().build();
        ApplicationProperties props = new ApplicationProperties(cfg);
        final SimpleBootstrap boot = new SimpleBootstrap(props);
        boot.run(new String[0]);
        try {
            Timestamp req = Timestamp.newBuilder().setSeconds(TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis())).build();
            ApiFactory apiFactory = (ApiFactory)Mockito.mock(ApiFactory.class);
            HeadersFacade headersw = (HeadersFacade)Mockito.mock(HeadersFacade.class);
            Mockito.when((Object)headersw.getMessageId()).thenReturn((Object)UUID.randomUUID().toString());
            ResponseStatusFacade statusw = (ResponseStatusFacade)Mockito.mock(ResponseStatusFacade.class);
            Mockito.when((Object)statusw.isSystem()).thenReturn((Object)true);
            ResponseWrapperFacade respw = (ResponseWrapperFacade)Mockito.mock(ResponseWrapperFacade.class);
            Mockito.when((Object)respw.status()).thenReturn((Object)statusw);
            RequestWrapperFacade reqw = (RequestWrapperFacade)Mockito.mock(RequestWrapperFacade.class);
            Mockito.when((Object)reqw.headers()).thenReturn((Object)headersw);
            Mockito.when((Object)reqw.body()).thenReturn((Object)Any.pack((Message)req));
            Mockito.when((Object)reqw.toExceptionalReply((Message)ArgumentMatchers.any(), (Throwable)ArgumentMatchers.any())).thenReturn((Object)respw);
            SafeRequestHandler handler = new SafeRequestHandler(reqw, apiFactory, (Span)NoopSpan.INSTANCE, this.unit, (TransactionalRequest)new EmbeddedTransactionalRequest(Timestamp.class, (Message.Builder)Timestamp.newBuilder(), this.unit, reqw, this.latch), (TransactionalRequestHandler)new TransactionalRequestHandler<Timestamp, Timestamp.Builder>(){

                public boolean actorIsRequired() {
                    return true;
                }

                public boolean isImmediateAcknowledge() {
                    return false;
                }

                public void apply(TransactionalRequest<Timestamp, Timestamp.Builder> cmd) throws Exception {
                    cmd.replyWhen(boot.globalPlatform().submit((Callable)new Callable<Timestamp>(){

                        @Override
                        public Timestamp call() throws Exception {
                            throw new RuntimeException("unable to complete");
                        }
                    }));
                }
            });
            handler.setBootstrap((Bootstrap)boot);
            WorkerCompletableTask task = handler.get();
            handler.run();
            TransactionalRequestOutcome operationOutcome = task.get();
            Assertions.assertTrue((boolean)operationOutcome.getNotifications().isEmpty());
            Assertions.assertTrue((boolean)operationOutcome.getReply().status().isSystem());
        }
        finally {
            boot.shutdown();
        }
    }
}

