/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.google.common.io.ByteSource;
import com.google.common.net.HostAndPort;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.ups.H2ServiceInfo;
import com.turbospaces.ups.PlainServiceInfo;
import com.turbospaces.ups.RawServiceInfo;
import com.turbospaces.ups.UPSs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.LocalDate;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.cloud.service.ServiceInfo;
import org.springframework.cloud.service.common.RedisServiceInfo;
import org.springframework.util.ResourceUtils;
import org.springframework.util.SocketUtils;

public class MockCloud {
    private final Properties cloudPropsOverride = new Properties();
    private final ApplicationConfig cfg;
    private final List<ServiceInfo> services = new LinkedList<ServiceInfo>();
    private final String spaceName;
    private final String appId;
    private final String appName;

    private MockCloud(String appId, String appName) throws ConfigException {
        this.appId = Objects.requireNonNull(appId);
        this.appName = Objects.requireNonNull(appName);
        this.spaceName = RandomStringUtils.randomAlphabetic((int)4);
        this.cfg = ApplicationConfig.create();
    }

    public MockCloud withKafka(int port) {
        return this.withKafka(HostAndPort.fromParts((String)"localhost", (int)port));
    }

    public MockCloud withKafka(HostAndPort addr) {
        PlainServiceInfo info = UPSs.toKafkaServiceInfo(addr);
        this.addUserProvidedService((ServiceInfo)info);
        return this;
    }

    public MockCloud withRedis(int port) {
        return this.withRedis(HostAndPort.fromParts((String)"localhost", (int)port));
    }

    public MockCloud withRedis(HostAndPort addr) {
        RedisServiceInfo info = new RedisServiceInfo("redis", addr.getHost(), addr.getPort(), "na");
        this.addUserProvidedService((ServiceInfo)info);
        return this;
    }

    public MockCloud withWeb3j(int port) {
        return this.withWeb3j(HostAndPort.fromParts((String)"localhost", (int)port));
    }

    public MockCloud withWeb3j(HostAndPort addr) {
        PlainServiceInfo info = UPSs.toWeb3jServiceInfo(addr);
        this.addUserProvidedService((ServiceInfo)info);
        return this;
    }

    public MockCloud withWeb3Credentials(String password, File folder) {
        String path = String.format("file://api_key:%s%s", password, folder.getAbsolutePath());
        PlainServiceInfo info = new PlainServiceInfo("web3j-credentials", path);
        this.addUserProvidedService((ServiceInfo)info);
        return this;
    }

    public MockCloud withRawService(String id, URL url) throws IOException {
        try (final InputStream io = url.openStream();){
            RawServiceInfo serviceInfo = new RawServiceInfo(id, new ByteSource(){

                public InputStream openStream() throws IOException {
                    return io;
                }
            }.read());
            this.addUserProvidedService(serviceInfo);
            MockCloud mockCloud = this;
            return mockCloud;
        }
    }

    public MockCloud withH2(boolean durable) {
        return this.withH2(durable, this.spaceName);
    }

    public MockCloud withH2(boolean durable, String namespace) {
        String url = "h2://mem:" + namespace;
        if (durable) {
            url = url + ";DB_CLOSE_DELAY=-1";
        }
        H2ServiceInfo ownerInfo = new H2ServiceInfo("h2-owner", url);
        H2ServiceInfo appInfo = new H2ServiceInfo("h2-app", url);
        this.addUserProvidedService((ServiceInfo)ownerInfo);
        this.addUserProvidedService((ServiceInfo)appInfo);
        return this;
    }

    public MockCloud appPort(int port) {
        this.cloudPropsOverride.put("cloud.application.port", (Object)port);
        return this;
    }

    public MockCloud addUserProvidedService(ServiceInfo info) {
        this.services.add(info);
        return this;
    }

    public ApplicationConfig build() throws Exception {
        String slot = "0";
        int port = SocketUtils.findAvailableTcpPort();
        String hostname = PlatformUtil.detectIp();
        Properties props = new Properties();
        props.put("cloud.application.app-id", this.appId);
        props.put("cloud.application.space_name", this.spaceName);
        props.put("cloud.application.host", hostname);
        props.put("cloud.application.port", (Object)port);
        props.put("cloud.application.instance_index", slot);
        props.put("cloud.application.name", this.appName);
        props.putAll((Map<?, ?>)this.cloudPropsOverride);
        this.cfg.setLocalProperty("app.shutdown-hook.enabled", false);
        this.cfg.setLocalProperties(UPSs.addUserProvideServices(props, this.services));
        return this.cfg;
    }

    public static MockCloud fromClasspathAppProps() throws Exception {
        URL resource = ResourceUtils.getURL((String)"classpath:application.properties");
        return MockCloud.fromClasspathAppProps(resource);
    }

    public static MockCloud fromClasspathAppProps(URL url) throws Exception {
        try (InputStream io = url.openStream();){
            Properties props = new Properties();
            props.load(io);
            String appId = props.getProperty("cloud.application.app-id");
            String appName = props.getProperty("cloud.application.name", MockCloud.randomAppName());
            MockCloud mockCloud = new MockCloud(appId, appName);
            return mockCloud;
        }
    }

    public static MockCloud newMock() throws ConfigException {
        int length = MockCloud.class.getSimpleName().length();
        String randomAppId = "app-" + RandomStringUtils.randomAlphanumeric((int)length);
        return new MockCloud(randomAppId, MockCloud.randomAppName());
    }

    private static String randomAppName() {
        int length = MockCloud.class.getSimpleName().length();
        LocalDate now = LocalDate.now();
        String randomGroup = "group-" + RandomStringUtils.randomAlphanumeric((int)length);
        String randomAppId = "app-" + RandomStringUtils.randomAlphanumeric((int)length);
        String randomVersion = now.getYear() + "" + now.getMonthValue() + "" + now.getDayOfMonth();
        String randomAppName = String.format("%s:%s:%s", randomGroup, randomAppId, randomVersion);
        return randomAppName;
    }
}

