package com.turbospaces.mdc;

import java.util.Objects;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.MDC;

import com.turbospaces.api.facade.HeadersFacade;
import com.turbospaces.executor.WorkUnit;

import io.netty.util.AsciiString;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;
import lombok.extern.slf4j.Slf4j;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
@Slf4j
public class MdcUtil {
    public static void setMdc(WorkUnit record, String operation, HeadersFacade headers) {
        var messageId = headers.getMessageId();
        var traceId = headers.getTraceId();

        MDC.put(MdcTags.MDC_OPERATION, operation);
        MDC.put(MdcTags.MDC_MESSAGE_ID, messageId);
        if (StringUtils.isNotEmpty(traceId)) {
            MDC.put(MdcTags.MDC_TRACE_ID, traceId);
        }
        if (Objects.nonNull(record.topic())) {
            MDC.put(MdcTags.MDC_TOPIC, record.topic());
        }
        if (Objects.nonNull(record.key())) {
            AsciiString partitionKey = new AsciiString(record.key());
            MDC.put(MdcTags.MDC_ROUTING_KEY, partitionKey.toString());
        }

        if (log.isTraceEnabled()) {
            log.trace("MDC before: {}", MDC.getCopyOfContextMap());
        }
    }
    public static void clearMdc(WorkUnit record) {
        MDC.remove(MdcTags.MDC_OPERATION);
        MDC.remove(MdcTags.MDC_MESSAGE_ID);
        MDC.remove(MdcTags.MDC_TOPIC);

        if (Objects.nonNull(record.key())) {
            MDC.remove(MdcTags.MDC_TRACE_ID);
        }
        if (Objects.nonNull(record.key())) {
            MDC.remove(MdcTags.MDC_ROUTING_KEY);
        }

        if (log.isTraceEnabled()) {
            log.trace("MDC after: {}", MDC.getCopyOfContextMap());
        }
    }
}
