/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cfg;

import com.netflix.archaius.api.Property;
import com.turbospaces.cfg.ApplicationConfig;
import com.turbospaces.cfg.DynamicPropertyFactory;
import com.turbospaces.common.PlatformUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import reactor.core.scheduler.Scheduler;
import reactor.util.retry.Retry;

public class ApplicationProperties {
    public static final int DEFAULT_PORT = 8089;
    public static final String NETTY_PREFIX = "netty.";
    public static final String JETTY_PREFIX = "jetty.";
    public static final String QUARTZ_PREFIX = "quartz.";
    public static final String JDBC_PREFIX = "jdbc.";
    public static final String FLINK_PREFIX = "flink.";
    public static final String KAFKA_PREFIX = "kafka.";
    public static final String ZK_PREFIX = "zk.";
    public static final String TCP_PREFIX = "tcp.";
    public static final String APP_PREFIX = "app.";
    public static final String REDIS_PREFIX = "redis.";
    public static final String HTTP_PREFIX = "http.";
    public static final String CACHE_PREFIX = "cache.";
    public static final String USERNAME = System.getProperty("user.name");
    public static final String TMP_DIR = System.getProperty("java.io.tmpdir");
    public static final String APP_DEV_MODE_KEY = "app.dev.mode";
    public static final String APP_DNS_QUERY_KEY = "app.dns.query";
    public static final String APP_BACKOFF_RETRY_FIRST_KEY = "app.backoff-retry.first";
    public static final String APP_BACKOFF_RETRY_MAX_KEY = "app.backoff-retry.max";
    public static final String APP_BACKOFF_RETRY_NUM_KEY = "app.backoff-retry.num";
    public static final String APP_SENTRY_ENABLED_KEY = "app.sentry.enabled";
    public static final String APP_USE_SELF_SIGNED_CERTIFICATE_KEY = "app.use.self-signed-certificate";
    public static final String APP_LOGGING_RESET_TO_KEY = "app.logging.reset-to";
    public static final String APP_LOGGING_DRY_RUN_KEY = "app.logging.dry-run";
    public static final String APP_METRICS_DRY_RUN_KEY = "app.metrics.dry-run";
    public static final String APP_METRICS_ELK_REPORTER_ENABLED_KEY = "app.metrics.elk-reporter.enabled";
    public static final String APP_METRICS_INFLUX_REPORTER_ENABLED_KEY = "app.metrics.influx-reporter.enabled";
    public static final String APP_METRICS_PROMETHEUS_REPORTER_ENABLED_KEY = "app.metrics.prometheus-reporter.enabled";
    public static final String APP_ALERTS_DRY_RUN_KEY = "app.alerts.dry-run";
    public static final String APP_EXTERNAL_IP_KEY = "app.external.ip";
    public static final String APP_JMX_DOMAIN_KEY = "app.jmx.domain";
    public static final String APP_ALLOWED_ORIGINS_KEY = "app.allowed-origins";
    public static final String APP_BASIC_AUTH_KEY = "app.basic-auth";
    public static final String APP_DB_MIGRATION_ENABLED_KEY = "app.db-migration.enabled";
    public static final String APP_DB_MIGRATION_PATH_KEY = "app.db-migration.path";
    public static final String APP_CONTRACTS_MIGRATION_ENABLED_KEY = "app.contracts-migration.enabled";
    public static final String APP_GRACEFUL_SHUTDOWN_TIMEOUNT_KEY = "app.graceful-shutdown.timeout";
    public static final String APP_PLATFORM_POOL_SIZE_KEY = "app.platform.pool-size";
    public static final String APP_PLATFORM_MAX_IDLE_KEY = "app.platform.max-idle";
    public static final String APP_PLATFORM_GRACEFUL_TIMEOUT_KEY = "app.platform.graceful-shutdown-timeout";
    public static final String APP_TIMER_INTERVAL_KEY = "app.timer.interval";
    public static final String APP_METRICS_BULK_SIZE_KEY = "app.metrics.bulk-size";
    public static final String APP_EXPONENTIAL_BACKOFF_KEY = "app.exponential.backoff";
    public static final String APP_HEAP_DUMP_ON_OOM_ENABLED_KEY = "app.heap-dump-on-oom.enabled";
    public static final String APP_HEAP_DUMP_DIR_KEY = "app.heap-dump.dir";
    public static final String APP_WAIT_FOR_HEALTHCHECKS_INTERVAL_KEY = "app.wait-for-healthchecks.interval";
    public static final String APP_WAIT_FOR_HEALTHCHECKS_ENABLED_KEY = "app.wait-for-healthchecks.enabled";
    public static final String APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT_KEY = "app.wait-for-healthchecks.timeout";
    public static final String APP_DATA_START_CLEAN_KEY = "app.data.start-clean";
    public static final String APP_SHUTDOWN_HOOK_ENABLED_KEY = "app.shutdown-hook.enabled";
    public static final String APP_CLEAR_CFG_AT_SHUTDOWN_ENABLED_KEY = "app.clear-config-at-shutdown.enabled";
    public static final String APP_CFG_DYNAMIC_POLLING_ENABLED_KEY = "app.cfg-dynamic-polling.enabled";
    public static final String HTTP_POOL_MIN_SIZE_KEY = "http.pool.min-size";
    public static final String HTTP_POOL_MAX_SIZE_KEY = "http.pool.max-size";
    public static final String REDIS_POOL_MIN_SIZE_KEY = "redis.pool.min-size";
    public static final String REDIS_POOL_MAX_SIZE_KEY = "redis.pool.max-size";
    public static final String TCP_REUSE_ADDRESS_KEY = "tcp.reuse-address";
    public static final String TCP_NODELAY_KEY = "tcp.no-delay";
    public static final String TCP_KEEP_ALIVE_KEY = "tcp.keep-alive";
    public static final String TCP_KEEP_ALIVE_TIMEOUT_KEY = "tcp.keep-alive.timeout";
    public static final String TCP_CONNECTION_TIMEOUT_KEY = "tcp.connection.timeout";
    public static final String TCP_SOCKET_TIMEOUT_KEY = "tcp.socket.timeout";
    public static final String TCP_SOCKET_BACKLOG_KEY = "tcp.socket.backlog";
    public static final String TCP_MAX_FRAME_SIZE_KEY = "tcp.max-frame-size";
    public static final String ZK_SESSION_TIMEOUT_KEY = "zk.session.timeout";
    public static final String ZK_CONNECT_TIMEOUT_KEY = "zk.connect.timeout";
    public static final String ZK_RETRY_INITIAL_KEY = "zk.retry.initial";
    public static final String ZK_RETRY_MAX_KEY = "zk.retry.max";
    public static final String NETTY_ACCEPTOR_POOL_SIZE_KEY = "netty.acceptor-pool.size";
    public static final String NETTY_WORKER_POOL_SIZE_KEY = "netty.worker-pool.size";
    public static final String JETTY_POOL_MAX_SIZE_KEY = "jetty.pool.max-size";
    public static final String JETTY_POOL_MIN_SIZE_KEY = "jetty.pool.min-size";
    public static final String JETTY_POOL_QUEUE_MAX_SIZE_KEY = "jetty.pool.queue-max-size";
    public static final String JETTY_POOL_IDLE_KEY = "jetty.pool.max-idle";
    public static final String JETTY_HTTP_SEND_DATE_HEADER_KEY = "jetty.http.send-date-header";
    public static final String JETTY_GZIP_ENABLED_KEY = "jetty.gzip.enabled";
    public static final String JETTY_GZIP_MIN_RESPONSE_SIZE_KEY = "jetty.gzip.min-response-size";
    public static final String FLINK_DEFAULT_PARALLELISM_KEY = "flink.default.parallelism";
    public static final String FLINK_CHECKPOINT_ENABLED_KEY = "flink.checkpoint.enabled";
    public static final String FLINK_CHECKPOINT_INTERVAL_KEY = "flink.checkpoint.interval";
    public static final String FLINK_CHECKPOINT_TIMEOUT_KEY = "flink.checkpoint.timeout";
    public static final String FLINK_CHECKPOINT_MAX_CONCURRENT_KEY = "flink.checkpoint.max-concurrent";
    public static final String FLINK_CHECKPOINT_MAX_RESTART_ATTEMPTS_KEY = "flink.checkpoint.max-restart-attempts";
    public static final String FLINK_CHECKPOINT_DELAY_BETWEEN_ATTEMPTS_KEY = "flink.checkpoint.delay-between-attempts";
    public static final String FLINK_STATE_BACKEND_PATH_KEY = "flink.state-backend.path";
    public static final String KAFKA_POLL_TIMEOUT_KEY = "kafka.poll.timeout";
    public static final String KAFKA_MAX_BLOCK_KEY = "kafka.max-block";
    public static final String KAFKA_ENABLE_IDEMPOTENCE_KEY = "kafka.enable.idempotence";
    public static final String KAFKA_ACKS_KEY = "kafka.acks";
    public static final String KAFKA_COMPRESSION_TYPE_KEY = "kafka.compression.type";
    public static final String KAFKA_MAX_REQUEST_SIZE_KEY = "kafka.max.request.size";
    public static final String KAFKA_AUTO_OFFSET_RESET_KEY = "kafka.auto.offset.reset";
    public static final String KAFKA_HEARTBEAT_INTERVAL_KEY = "kafka.heartbeat.interval";
    public static final String KAFKA_SESSION_TIMEOUT_KEY = "kafka.session.timeout";
    public static final String KAFKA_POLL_MAX_INTERVAL_KEY = "kafka.poll.max-interval";
    public static final String KAFKA_POLL_MAX_RECORDS_KEY = "kafka.poll.max-records";
    public static final String KAFKA_POLL_MAX_RATE_KEY = "kafka.poll.rate";
    public static final String KAFKA_QUEUE_MAX_SIZE_KEY = "kafka.queue.max-size";
    public static final String KAFKA_MAX_WORKERS_KEY = "kafka.max-workers";
    public static final String QUARTZ_SCHEDULER_NAME_KEY = "quartz.scheduler.name";
    public static final String QUARTZ_SCHEDULER_ID_KEY = "quartz.scheduler.id";
    public static final String QUARTZ_SCHEDULER_POOL_COUNT_KEY = "quartz.worker-pool.count";
    public static final String QUARTZ_JOBSTORE_TABLE_PREFIX_KEY = "quartz.jobstore.table-prefix";
    public static final String QUARTZ_JOBSTORE_USE_PROPS_KEY = "quartz.jobstore.use-props";
    public static final String QUARTZ_JOBSTORE_ACQUIRE_TRIGGERS_WITHIN_LOCK_KEY = "quartz.jobstore.acquire-triggers-within-lock";
    public static final String QUARTZ_JOBSTORE_IS_CLUSTERED_KEY = "quartz.jobstore.is-clustered";
    public static final String QUARTZ_CONNECTION_POOL_MIN_KEY = "quartz.connection-pool.min";
    public static final String QUARTZ_CONNECTION_POOL_MAX_KEY = "quartz.connection-pool.max";
    public static final String QUARTZ_INSTANCE_ID_KEY = "quartz.instance.id";
    public static final String QUARTZ_AUTO_RECOVERY_INTERVAL_KEY = "quartz.auto-recovery.interval";
    public static final String JDBC_PERSIST_BATCH_SIZE_KEY = "jdbc.persist-batch.size";
    public static final String JDBC_QUERY_BATCH_SIZE_KEY = "jdbc.query-batch.size";
    public static final String JDBC_LAZY_BATCH_SIZE_KEY = "jdbc.lazy-batch.size";
    public static final String JDBC_LAZY_SEQUENCE_BATCH_SIZE_KEY = "jdbc.lazy-sequence-batch.size";
    public static final String JDBC_CONNECTION_TIMEOUT_KEY = "jdbc.connection.timeout";
    public static final String JDBC_LEAK_DETECTION_THRESHOLD_KEY = "jdbc.leak-detection-threshold.timeout";
    public static final String JDBC_DEFAULT_INSTANCE_KEY = "jdbc.default.instance";
    public static final String JDBC_CONNECTION_POOL_MIN_SIZE_KEY = "jdbc.pool.min-size";
    public static final String JDBC_CONNECTION_POOL_MAX_SIZE_KEY = "jdbc.pool.max-size";
    public static final String JDBC_READ_ONLY_CONNECTION_POOL_MIN_SIZE_KEY = "jdbc.read-only-pool.min-size";
    public static final String JDBC_READ_ONLY_CONNECTION_POOL_MAX_SIZE_KEY = "jdbc.read-only-pool.max-size";
    public static final String CACHE_DEFAULT_MAX_TTL_KEY = "cache.default.max-ttl";
    public static final String CACHE_DEFAULT_MAX_IDLE_KEY = "cache.default.max-idle";
    public static final String CACHE_DEFAULT_MAX_SIZE_KEY = "cache.default.max-size";
    public static final String CACHE_REPLICATED_NEVER_EXPIRE_KEY = "cache.replicated.never-expire";
    public static final String CACHE_LOCAL_NEVER_EXPIRE_KEY = "cache.local.never-expire";
    public final Property<Boolean> TCP_REUSE_ADDRESS;
    public final Property<Boolean> TCP_NODELAY;
    public final Property<Boolean> TCP_KEEP_ALIVE;
    public final Property<Integer> TCP_KEEP_ALIVE_TIMEOUT;
    public final Property<Integer> TCP_CONNECTION_TIMEOUT;
    public final Property<Integer> TCP_SOCKET_TIMEOUT;
    public final Property<Integer> TCP_SOCKET_BACKLOG;
    public final Property<Integer> TCP_MAX_FRAME_SIZE;
    public final Property<Integer> NETTY_ACCEPTOR_POOL_SIZE;
    public final Property<Integer> NETTY_WORKER_POOL_SIZE;
    public final Property<Integer> JETTY_POOL_MAX_SIZE;
    public final Property<Integer> JETTY_POOL_MIN_SIZE;
    public final Property<Integer> JETTY_POOL_QUEUE_MAX_SIZE;
    public final Property<Integer> JETTY_POOL_IDLE;
    public final Property<Boolean> JETTY_HTTP_SEND_DATE_HEADER;
    public final Property<Boolean> JETTY_GZIP_ENABLED;
    public final Property<Integer> JETTY_GZIP_MIN_RESPONSE_SIZE;
    public final Property<Integer> ZK_SESSION_TIMEOUT;
    public final Property<Integer> ZK_RETRY_INITIAL;
    public final Property<Integer> ZK_RETRY_MAX;
    public final Property<String> CLOUD_APP_ID;
    public final Property<String> CLOUD_APP_SPACE_NAME;
    public final Property<String> CLOUD_APP_NAME;
    public final Property<String> CLOUD_APP_INSTANCE_INDEX;
    public final Property<String> CLOUD_APP_HOST;
    public final Property<Integer> CLOUD_APP_PORT;
    public final Property<Boolean> APP_DEV_MODE;
    public final Property<String> APP_DNS_QUERY;
    public final Property<Integer> APP_BACKOFF_RETRY_FIRST;
    public final Property<Integer> APP_BACKOFF_RETRY_MAX;
    public final Property<Integer> APP_BACKOFF_RETRY_NUM;
    public final Property<Boolean> APP_SENTRY_ENABLED;
    public final Property<Boolean> APP_USE_SELF_SIGNED_CERTIFICATE;
    public final Property<String> APP_LOGGING_RESET_TO;
    public final Property<Boolean> APP_LOGGING_DRY_RUN;
    public final Property<Boolean> APP_METRICS_DRY_RUN;
    public final Property<Boolean> APP_METRICS_ELK_REPORTER_ENABLED;
    public final Property<Boolean> APP_METRICS_INFLUX_REPORTER_ENABLED;
    public final Property<Boolean> APP_METRICS_PROMETHEUS_REPORTER_ENABLED;
    public final Property<Boolean> APP_ALERTS_DRY_RUN;
    public final Property<String> APP_EXTERNAL_IP;
    public final Property<String> APP_JMX_DOMAIN;
    public final Property<String> APP_ALLOWED_ORIGINS;
    public final Property<String> APP_BASIC_AUTH;
    public final Property<Boolean> APP_DB_MIGRATION_ENABLED;
    public final Property<String> APP_DB_MIGRATION_PATH;
    public final Property<Boolean> APP_CONTRACTS_MIGRATION_ENABLED;
    public final Property<Integer> APP_GRACEFUL_SHUTDOWN_TIMEOUNT;
    public final Property<Integer> APP_PLATFORM_POOL_SIZE;
    public final Property<Integer> APP_PLATFORM_MAX_IDLE;
    public final Property<Integer> APP_PLATFORM_GRACEFUL_TIMEOUT;
    public final Property<Integer> APP_TIMER_INTERVAL;
    public final Property<Integer> APP_METRICS_BULK_SIZE;
    public final Property<Double> APP_EXPONENTIAL_BACKOFF;
    public final Property<Boolean> APP_HEAP_DUMP_ON_OOM_ENABLED;
    public final Property<String> APP_HEAP_DUMP_DIR;
    public final Property<Boolean> APP_DATA_START_CLEAN;
    public final Property<Integer> APP_WAIT_FOR_HEALTHCHECKS_INTERVAL;
    public final Property<Boolean> APP_WAIT_FOR_HEALTHCHECKS_ENABLED;
    public final Property<Integer> APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT;
    public final Property<Boolean> APP_SHUTDOWN_HOOK_ENABLED;
    public final Property<Boolean> APP_CLEAR_CFG_AT_SHUTDOWN_ENABLED;
    public final Property<Boolean> APP_CFG_DYNAMIC_POLLING_ENABLED;
    public final Property<Integer> HTTP_POOL_MIN_SIZE;
    public final Property<Integer> HTTP_POOL_MAX_SIZE;
    public final Property<Integer> REDIS_POOL_MIN_SIZE;
    public final Property<Integer> REDIS_POOL_MAX_SIZE;
    public final Property<Integer> FLINK_DEFAULT_PARALLELISM;
    public final Property<Boolean> FLINK_CHECKPOINT_ENABLED;
    public final Property<Integer> FLINK_CHECKPOINT_INTERVAL;
    public final Property<Integer> FLINK_CHECKPOINT_TIMEOUT;
    public final Property<Integer> FLINK_CHECKPOINT_MAX_CONCURRENT;
    public final Property<Integer> FLINK_CHECKPOINT_MAX_RESTART_ATTEMPTS;
    public final Property<Integer> FLINK_CHECKPOINT_DELAY_BETWEEN_ATTEMPTS;
    public final Property<String> FLINK_STATE_BACKEND_PATH;
    public final Property<Integer> KAFKA_MAX_BLOCK;
    public final Property<Boolean> KAFKA_ENABLED_IDEMPOTENCE;
    public final Property<String> KAFKA_ACKS;
    public final Property<String> KAFKA_COMPRESSION_TYPE;
    public final Property<Integer> KAFKA_MAX_REQUEST_SIZE;
    public final Property<String> KAFKA_AUTO_OFFSET_RESET;
    public final Property<Integer> KAFKA_HEARTBEAT_INTERVAL;
    public final Property<Integer> KAFKA_SESSION_TIMEOUT;
    public final Property<Integer> KAFKA_POLL_MAX_INTERVAL;
    public final Property<Integer> KAFKA_POLL_MAX_RECORDS;
    public final Property<Integer> KAFKA_QUEUE_MAX_SIZE;
    public final Property<Integer> KAFKA_MAX_WORKERS;
    public final Property<String> QUARTZ_SCHEDULER_ID;
    public final Property<Integer> QUARTZ_SCHEDULER_POOL_COUNT;
    public final Property<String> QUARTZ_JOBSTORE_TABLE_PREFIX;
    public final Property<Boolean> QUARTZ_JOBSTORE_USE_PROPS;
    public final Property<Boolean> QUARTZ_JOBSTORE_ACQUIRE_TRIGGERS_WITHIN_LOCK;
    public final Property<Integer> QUARTZ_CONNECTION_POOL_MIN;
    public final Property<Integer> QUARTZ_CONNECTION_POOL_MAX;
    public final Property<Boolean> QUARTZ_JOBSTORE_IS_CLUSTERED;
    public final Property<String> QUARTZ_INSTANCE_ID;
    public final Property<Integer> QUARTZ_AUTO_RECOVERY_INTERVAL;
    public final Property<Integer> JDBC_PERSIST_BATCH_SIZE;
    public final Property<Integer> JDBC_QUERY_BATCH_SIZE;
    public final Property<Integer> JDBC_LAZY_BATCH_SIZE;
    public final Property<Integer> JDBC_LAZY_SEQUENCE_BATCH_SIZE;
    public final Property<Integer> JDBC_CONNECTION_POOL_MIN_SIZE;
    public final Property<Integer> JDBC_CONNECTION_POOL_MAX_SIZE;
    public final Property<Integer> JDBC_READ_ONLY_CONNECTION_POOL_MIN_SIZE;
    public final Property<Integer> JDBC_READ_ONLY_CONNECTION_POOL_MAX_SIZE;
    public final Property<Integer> JDBC_LEAK_DETECTION_THRESHOLD;
    public final Property<Integer> JDBC_CONNECTION_TIMEOUT;
    public final Property<Boolean> JDBC_DEFAULT_INSTANCE;
    public final Property<Integer> CACHE_DEFAULT_MAX_TTL;
    public final Property<Integer> CACHE_DEFAULT_MAX_IDLE;
    public final Property<Integer> CACHE_DEFAULT_MAX_SIZE;
    public final Property<Boolean> CACHE_REPLICATED_NEVER_EXPIRE;
    public final Property<Boolean> CACHE_LOCAL_NEVER_EXPIRE;
    private final ApplicationConfig cfg;

    public ApplicationProperties(ApplicationConfig cfg) {
        this.cfg = Objects.requireNonNull(cfg);
        DynamicPropertyFactory pf = cfg.factory();
        this.CLOUD_APP_ID = pf.get("cloud.application.app-id", String.class).orElse((Object)USERNAME);
        this.CLOUD_APP_INSTANCE_INDEX = pf.get("cloud.application.instance_index", String.class).orElse((Object)"0");
        this.CLOUD_APP_NAME = pf.get("cloud.application.name", String.class);
        this.CLOUD_APP_SPACE_NAME = pf.get("cloud.application.space_name", String.class);
        this.CLOUD_APP_HOST = pf.get("cloud.application.host", String.class).orElse((Object)"localhost");
        this.CLOUD_APP_PORT = pf.get("cloud.application.port", Integer.TYPE).orElse((Object)8089);
        this.TCP_REUSE_ADDRESS = pf.get(TCP_REUSE_ADDRESS_KEY, Boolean.TYPE).orElse((Object)true);
        this.TCP_NODELAY = pf.get(TCP_NODELAY_KEY, Boolean.TYPE).orElse((Object)true);
        this.TCP_KEEP_ALIVE = pf.get(TCP_KEEP_ALIVE_KEY, Boolean.TYPE).orElse((Object)true);
        this.TCP_KEEP_ALIVE_TIMEOUT = pf.get(TCP_KEEP_ALIVE_TIMEOUT_KEY, Integer.TYPE).orElse((Object)30);
        this.TCP_CONNECTION_TIMEOUT = pf.get(TCP_CONNECTION_TIMEOUT_KEY, Integer.TYPE).orElse((Object)10);
        this.TCP_SOCKET_TIMEOUT = pf.get(TCP_SOCKET_TIMEOUT_KEY, Integer.TYPE).orElse((Object)60);
        this.TCP_SOCKET_BACKLOG = pf.get(TCP_SOCKET_BACKLOG_KEY, Integer.TYPE).orElse((Object)1024);
        this.TCP_MAX_FRAME_SIZE = pf.get(TCP_MAX_FRAME_SIZE_KEY, Integer.TYPE).orElse((Object)0x1000000);
        this.APP_DEV_MODE = pf.get(APP_DEV_MODE_KEY, Boolean.TYPE).orElse((Object)true);
        this.APP_DNS_QUERY = pf.get(APP_DNS_QUERY_KEY, String.class);
        this.APP_BACKOFF_RETRY_FIRST = pf.get(APP_BACKOFF_RETRY_FIRST_KEY, Integer.TYPE).orElse((Object)1);
        this.APP_BACKOFF_RETRY_MAX = pf.get(APP_BACKOFF_RETRY_MAX_KEY, Integer.TYPE).orElse((Object)30);
        this.APP_BACKOFF_RETRY_NUM = pf.get(APP_BACKOFF_RETRY_NUM_KEY, Integer.TYPE).orElse((Object)10);
        this.APP_SENTRY_ENABLED = pf.get(APP_SENTRY_ENABLED_KEY, Boolean.TYPE).orElse((Object)true);
        this.APP_USE_SELF_SIGNED_CERTIFICATE = pf.get(APP_USE_SELF_SIGNED_CERTIFICATE_KEY, Boolean.class).orElse((Object)false);
        this.APP_LOGGING_RESET_TO = pf.get(APP_LOGGING_RESET_TO_KEY, String.class);
        this.APP_LOGGING_DRY_RUN = pf.get(APP_LOGGING_DRY_RUN_KEY, Boolean.TYPE).orElse((Object)false);
        this.APP_METRICS_DRY_RUN = pf.get(APP_METRICS_DRY_RUN_KEY, Boolean.TYPE).orElse((Object)false);
        this.APP_METRICS_ELK_REPORTER_ENABLED = pf.get(APP_METRICS_ELK_REPORTER_ENABLED_KEY, Boolean.TYPE).orElse((Object)false);
        this.APP_METRICS_INFLUX_REPORTER_ENABLED = pf.get(APP_METRICS_INFLUX_REPORTER_ENABLED_KEY, Boolean.TYPE).orElse((Object)false);
        this.APP_METRICS_PROMETHEUS_REPORTER_ENABLED = pf.get(APP_METRICS_PROMETHEUS_REPORTER_ENABLED_KEY, Boolean.TYPE).orElse((Object)false);
        this.APP_ALERTS_DRY_RUN = pf.get(APP_ALERTS_DRY_RUN_KEY, Boolean.TYPE).orElse((Object)false);
        this.APP_EXTERNAL_IP = pf.get(APP_EXTERNAL_IP_KEY, String.class).orElse((Object)PlatformUtil.fetchExternalIp(this));
        this.APP_JMX_DOMAIN = pf.get(APP_JMX_DOMAIN_KEY, String.class).orElse((Object)"metrics");
        this.APP_ALLOWED_ORIGINS = pf.get(APP_ALLOWED_ORIGINS_KEY, String.class);
        this.APP_BASIC_AUTH = pf.get(APP_BASIC_AUTH_KEY, String.class);
        this.APP_DB_MIGRATION_ENABLED = pf.get(APP_DB_MIGRATION_ENABLED_KEY, Boolean.TYPE).orElse((Object)true);
        this.APP_DB_MIGRATION_PATH = pf.get(APP_DB_MIGRATION_PATH_KEY, String.class).orElse((Object)"db/sql-migration");
        this.APP_CONTRACTS_MIGRATION_ENABLED = pf.get(APP_CONTRACTS_MIGRATION_ENABLED_KEY, Boolean.TYPE).orElse((Object)true);
        this.APP_GRACEFUL_SHUTDOWN_TIMEOUNT = pf.get(APP_GRACEFUL_SHUTDOWN_TIMEOUNT_KEY, Integer.TYPE).orElse((Object)45);
        this.APP_PLATFORM_POOL_SIZE = pf.get(APP_PLATFORM_POOL_SIZE_KEY, Integer.TYPE).orElse((Object)64);
        this.APP_PLATFORM_MAX_IDLE = pf.get(APP_PLATFORM_MAX_IDLE_KEY, Integer.TYPE).orElse((Object)10);
        this.APP_PLATFORM_GRACEFUL_TIMEOUT = pf.get(APP_PLATFORM_GRACEFUL_TIMEOUT_KEY, Integer.TYPE).orElse((Object)30);
        this.APP_TIMER_INTERVAL = pf.get(APP_TIMER_INTERVAL_KEY, Integer.TYPE).orElse((Object)15);
        this.APP_METRICS_BULK_SIZE = pf.get(APP_METRICS_BULK_SIZE_KEY, Integer.TYPE).orElse((Object)1024);
        this.APP_EXPONENTIAL_BACKOFF = pf.get(APP_EXPONENTIAL_BACKOFF_KEY, Double.TYPE).orElse((Object)1.2);
        this.APP_HEAP_DUMP_ON_OOM_ENABLED = pf.get(APP_HEAP_DUMP_ON_OOM_ENABLED_KEY, Boolean.TYPE).orElse((Object)true);
        this.APP_HEAP_DUMP_DIR = pf.get(APP_HEAP_DUMP_DIR_KEY, String.class).orElse((Object)TMP_DIR);
        this.APP_WAIT_FOR_HEALTHCHECKS_INTERVAL = pf.get(APP_WAIT_FOR_HEALTHCHECKS_INTERVAL_KEY, Integer.TYPE).orElse((Object)1);
        this.APP_WAIT_FOR_HEALTHCHECKS_ENABLED = pf.get(APP_WAIT_FOR_HEALTHCHECKS_ENABLED_KEY, Boolean.TYPE).orElse((Object)false);
        this.APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT = pf.get(APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT_KEY, Integer.TYPE).orElse((Object)60);
        this.APP_DATA_START_CLEAN = pf.get(APP_DATA_START_CLEAN_KEY, Boolean.TYPE).orElse((Object)false);
        this.APP_SHUTDOWN_HOOK_ENABLED = pf.get(APP_SHUTDOWN_HOOK_ENABLED_KEY, Boolean.TYPE).orElse((Object)true);
        this.APP_CLEAR_CFG_AT_SHUTDOWN_ENABLED = pf.get(APP_CLEAR_CFG_AT_SHUTDOWN_ENABLED_KEY, Boolean.TYPE).orElse((Object)false);
        this.APP_CFG_DYNAMIC_POLLING_ENABLED = pf.get(APP_CFG_DYNAMIC_POLLING_ENABLED_KEY, Boolean.TYPE).orElse((Object)true);
        this.HTTP_POOL_MIN_SIZE = pf.get(HTTP_POOL_MIN_SIZE_KEY, Integer.TYPE).orElse((Object)1);
        this.HTTP_POOL_MAX_SIZE = pf.get(HTTP_POOL_MAX_SIZE_KEY, Integer.TYPE).orElse((Object)50);
        this.REDIS_POOL_MIN_SIZE = pf.get(REDIS_POOL_MIN_SIZE_KEY, Integer.TYPE).orElse((Object)16);
        this.REDIS_POOL_MAX_SIZE = pf.get(REDIS_POOL_MAX_SIZE_KEY, Integer.TYPE).orElse((Object)64);
        this.ZK_SESSION_TIMEOUT = pf.get(ZK_SESSION_TIMEOUT_KEY, Integer.TYPE).orElse((Object)15);
        this.ZK_RETRY_INITIAL = pf.get(ZK_RETRY_INITIAL_KEY, Integer.TYPE).orElse((Object)1);
        this.ZK_RETRY_MAX = pf.get(ZK_RETRY_MAX_KEY, Integer.TYPE).orElse((Object)4);
        this.NETTY_ACCEPTOR_POOL_SIZE = pf.get(NETTY_ACCEPTOR_POOL_SIZE_KEY, Integer.TYPE).orElse((Object)1);
        this.NETTY_WORKER_POOL_SIZE = pf.get(NETTY_WORKER_POOL_SIZE_KEY, Integer.TYPE).orElse((Object)32);
        this.JETTY_POOL_MAX_SIZE = pf.get(JETTY_POOL_MAX_SIZE_KEY, Integer.TYPE).orElse((Object)64);
        this.JETTY_POOL_MIN_SIZE = pf.get(JETTY_POOL_MIN_SIZE_KEY, Integer.TYPE).orElse((Object)32);
        this.JETTY_POOL_QUEUE_MAX_SIZE = pf.get(JETTY_POOL_QUEUE_MAX_SIZE_KEY, Integer.TYPE).orElse((Object)16384);
        this.JETTY_POOL_IDLE = pf.get(JETTY_POOL_IDLE_KEY, Integer.TYPE).orElse((Object)((int)TimeUnit.MINUTES.toSeconds(5L)));
        this.JETTY_HTTP_SEND_DATE_HEADER = pf.get(JETTY_HTTP_SEND_DATE_HEADER_KEY, Boolean.TYPE).orElse((Object)false);
        this.JETTY_GZIP_ENABLED = pf.get(JETTY_GZIP_ENABLED_KEY, Boolean.TYPE).orElse((Object)true);
        this.JETTY_GZIP_MIN_RESPONSE_SIZE = pf.get(JETTY_GZIP_MIN_RESPONSE_SIZE_KEY, Integer.TYPE).orElse((Object)2048);
        this.FLINK_DEFAULT_PARALLELISM = pf.get(FLINK_DEFAULT_PARALLELISM_KEY, Integer.TYPE).orElse((Object)-1);
        this.FLINK_CHECKPOINT_ENABLED = pf.get(FLINK_CHECKPOINT_ENABLED_KEY, Boolean.TYPE).orElse((Object)true);
        this.FLINK_CHECKPOINT_INTERVAL = pf.get(FLINK_CHECKPOINT_INTERVAL_KEY, Integer.TYPE).orElse((Object)10);
        this.FLINK_CHECKPOINT_TIMEOUT = pf.get(FLINK_CHECKPOINT_TIMEOUT_KEY, Integer.TYPE).orElse((Object)((int)TimeUnit.MINUTES.toSeconds(1L)));
        this.FLINK_CHECKPOINT_MAX_CONCURRENT = pf.get(FLINK_CHECKPOINT_MAX_CONCURRENT_KEY, Integer.TYPE).orElse((Object)1);
        this.FLINK_CHECKPOINT_MAX_RESTART_ATTEMPTS = pf.get(FLINK_CHECKPOINT_MAX_RESTART_ATTEMPTS_KEY, Integer.TYPE).orElse((Object)30);
        this.FLINK_CHECKPOINT_DELAY_BETWEEN_ATTEMPTS = pf.get(FLINK_CHECKPOINT_DELAY_BETWEEN_ATTEMPTS_KEY, Integer.TYPE).orElse((Object)1);
        this.FLINK_STATE_BACKEND_PATH = pf.get(FLINK_STATE_BACKEND_PATH_KEY, String.class);
        this.KAFKA_MAX_BLOCK = pf.get(KAFKA_MAX_BLOCK_KEY, Integer.TYPE).orElse((Object)30);
        this.KAFKA_ENABLED_IDEMPOTENCE = pf.get(KAFKA_ENABLE_IDEMPOTENCE_KEY, Boolean.TYPE).orElse((Object)true);
        this.KAFKA_ACKS = pf.get(KAFKA_ACKS_KEY, String.class).orElse((Object)"all");
        this.KAFKA_COMPRESSION_TYPE = pf.get(KAFKA_COMPRESSION_TYPE_KEY, String.class).orElse((Object)"none");
        this.KAFKA_MAX_REQUEST_SIZE = pf.get(KAFKA_MAX_REQUEST_SIZE_KEY, Integer.TYPE).orElse((Object)0x400000);
        this.KAFKA_AUTO_OFFSET_RESET = pf.get(KAFKA_AUTO_OFFSET_RESET_KEY, String.class);
        this.KAFKA_HEARTBEAT_INTERVAL = pf.get(KAFKA_HEARTBEAT_INTERVAL_KEY, Integer.TYPE).orElse((Object)5);
        this.KAFKA_SESSION_TIMEOUT = pf.get(KAFKA_SESSION_TIMEOUT_KEY, Integer.TYPE).orElse((Object)30);
        this.KAFKA_POLL_MAX_INTERVAL = pf.get(KAFKA_POLL_MAX_INTERVAL_KEY, Integer.TYPE).orElse((Object)600);
        this.KAFKA_POLL_MAX_RECORDS = pf.get(KAFKA_POLL_MAX_RECORDS_KEY, Integer.TYPE).orElse((Object)1024);
        this.KAFKA_QUEUE_MAX_SIZE = pf.get(KAFKA_QUEUE_MAX_SIZE_KEY, Integer.TYPE).orElse((Object)1024);
        this.KAFKA_MAX_WORKERS = pf.get(KAFKA_MAX_WORKERS_KEY, Integer.TYPE).orElse((Object)64);
        this.QUARTZ_SCHEDULER_ID = pf.get(QUARTZ_SCHEDULER_ID_KEY, String.class).orElse((Object)"AUTO");
        this.QUARTZ_SCHEDULER_POOL_COUNT = pf.get(QUARTZ_SCHEDULER_POOL_COUNT_KEY, Integer.class).orElse((Object)8);
        this.QUARTZ_JOBSTORE_TABLE_PREFIX = pf.get(QUARTZ_JOBSTORE_TABLE_PREFIX_KEY, String.class).orElse((Object)"qrtz_");
        this.QUARTZ_JOBSTORE_USE_PROPS = pf.get(QUARTZ_JOBSTORE_USE_PROPS_KEY, Boolean.class).orElse((Object)false);
        this.QUARTZ_JOBSTORE_ACQUIRE_TRIGGERS_WITHIN_LOCK = pf.get(QUARTZ_JOBSTORE_ACQUIRE_TRIGGERS_WITHIN_LOCK_KEY, Boolean.class).orElse((Object)false);
        this.QUARTZ_JOBSTORE_IS_CLUSTERED = pf.get(QUARTZ_JOBSTORE_IS_CLUSTERED_KEY, Boolean.class).orElse((Object)false);
        this.QUARTZ_CONNECTION_POOL_MIN = pf.get(QUARTZ_CONNECTION_POOL_MIN_KEY, Integer.class).orElse((Object)1);
        this.QUARTZ_CONNECTION_POOL_MAX = pf.get(QUARTZ_CONNECTION_POOL_MAX_KEY, Integer.class).orElse((Object)5);
        this.QUARTZ_INSTANCE_ID = pf.get(QUARTZ_INSTANCE_ID_KEY, String.class);
        this.QUARTZ_AUTO_RECOVERY_INTERVAL = pf.get(QUARTZ_AUTO_RECOVERY_INTERVAL_KEY, Integer.TYPE).orElse((Object)1);
        this.JDBC_PERSIST_BATCH_SIZE = pf.get(JDBC_PERSIST_BATCH_SIZE_KEY, Integer.TYPE).orElse((Object)100);
        this.JDBC_QUERY_BATCH_SIZE = pf.get(JDBC_QUERY_BATCH_SIZE_KEY, Integer.TYPE).orElse((Object)250);
        this.JDBC_LAZY_BATCH_SIZE = pf.get(JDBC_LAZY_BATCH_SIZE_KEY, Integer.TYPE).orElse((Object)100);
        this.JDBC_LAZY_SEQUENCE_BATCH_SIZE = pf.get(JDBC_LAZY_SEQUENCE_BATCH_SIZE_KEY, Integer.TYPE).orElse((Object)1000);
        this.JDBC_CONNECTION_POOL_MIN_SIZE = pf.get(JDBC_CONNECTION_POOL_MIN_SIZE_KEY, Integer.TYPE).orElse((Object)1);
        this.JDBC_CONNECTION_POOL_MAX_SIZE = pf.get(JDBC_CONNECTION_POOL_MAX_SIZE_KEY, Integer.TYPE).orElse((Object)10);
        this.JDBC_READ_ONLY_CONNECTION_POOL_MIN_SIZE = pf.get(JDBC_READ_ONLY_CONNECTION_POOL_MIN_SIZE_KEY, Integer.TYPE).orElse((Object)1);
        this.JDBC_READ_ONLY_CONNECTION_POOL_MAX_SIZE = pf.get(JDBC_READ_ONLY_CONNECTION_POOL_MAX_SIZE_KEY, Integer.TYPE).orElse((Object)5);
        this.JDBC_CONNECTION_TIMEOUT = pf.get(JDBC_CONNECTION_TIMEOUT_KEY, Integer.TYPE).orElse((Object)30);
        this.JDBC_LEAK_DETECTION_THRESHOLD = pf.get(JDBC_LEAK_DETECTION_THRESHOLD_KEY, Integer.TYPE).orElse((Object)0);
        this.JDBC_DEFAULT_INSTANCE = pf.get(JDBC_DEFAULT_INSTANCE_KEY, Boolean.TYPE).orElse((Object)false);
        this.CACHE_DEFAULT_MAX_TTL = pf.get(CACHE_DEFAULT_MAX_TTL_KEY, Integer.TYPE).orElse((Object)60);
        this.CACHE_DEFAULT_MAX_IDLE = pf.get(CACHE_DEFAULT_MAX_IDLE_KEY, Integer.TYPE).orElse((Object)15);
        this.CACHE_DEFAULT_MAX_SIZE = pf.get(CACHE_DEFAULT_MAX_SIZE_KEY, Integer.TYPE).orElse((Object)4096);
        this.CACHE_REPLICATED_NEVER_EXPIRE = pf.get(CACHE_REPLICATED_NEVER_EXPIRE_KEY, Boolean.TYPE).orElse((Object)true);
        this.CACHE_LOCAL_NEVER_EXPIRE = pf.get(CACHE_LOCAL_NEVER_EXPIRE_KEY, Boolean.TYPE).orElse((Object)false);
    }

    public Retry retry(Scheduler scheduler) {
        int numRetries = (Integer)this.APP_BACKOFF_RETRY_NUM.get();
        Duration firstBackoff = Duration.ofSeconds(((Integer)this.APP_BACKOFF_RETRY_FIRST.get()).intValue());
        Duration maxBackoff = Duration.ofSeconds(((Integer)this.APP_BACKOFF_RETRY_MAX.get()).intValue());
        return Retry.backoff((long)numRetries, (Duration)firstBackoff).maxBackoff(maxBackoff).scheduler(scheduler);
    }

    public List<String> allowedOrigins() {
        final LinkedList allowedOrigins = new LinkedList();
        this.cfg.getStringList(this.APP_ALLOWED_ORIGINS).stream().forEach(new Consumer<String>(){

            @Override
            public void accept(String orig) {
                try {
                    allowedOrigins.add(new URL(orig));
                }
                catch (MalformedURLException err) {
                    throw new RuntimeException("bad origin", err);
                }
            }
        });
        return allowedOrigins.stream().map(psi -> {
            String allowedOrigin = psi.getProtocol() + "://" + psi.getHost();
            if (psi.getPort() > 0) {
                allowedOrigin = allowedOrigin + ":" + psi.getPort();
            }
            return allowedOrigin;
        }).collect(Collectors.toList());
    }

    public List<String> basicAuth() {
        return this.cfg.getStringList(this.APP_BASIC_AUTH);
    }

    public ApplicationConfig cfg() {
        return this.cfg;
    }
}

