package com.turbospaces.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledFuture;

public class RequestReplyFuture<T> extends CompletableFuture<T> {
    private final ScheduledFuture<?> timeoutTask;

    public RequestReplyFuture(ScheduledFuture<?> timeoutTask) {
        this.timeoutTask = timeoutTask;
    }
    @Override
    public boolean complete(T value) {
        boolean toReturn = super.complete( value );
        timeoutTask.cancel( false );
        return toReturn;
    }
}
