package com.turbospaces.common;

import io.vavr.CheckedRunnable;
import lombok.AccessLevel;
import lombok.NoArgsConstructor;

@NoArgsConstructor(access = AccessLevel.PRIVATE)
public class NonBlockingCallOnly {
    public static final ThreadLocal<Boolean> MARKER = ThreadLocal.withInitial(() -> false);

    public static void run(CheckedRunnable runnable) throws Throwable {
        try {
            MARKER.set(true);
            runnable.run();
        } finally {
            MARKER.remove();
        }
    }
}
