package com.turbospaces.rpc;

import java.io.IOException;

import com.google.protobuf.Message;
import com.turbospaces.api.facade.ResponseStatusFacade;
import com.turbospaces.api.facade.ResponseWrapperFacade;

import lombok.AllArgsConstructor;

@AllArgsConstructor
public class DefaultApiResponseEntity<T extends Message> implements ApiResponseEntity<T> {
    private final ResponseWrapperFacade wrapper;
    private final Class<T> type;

    @Override
    public ResponseStatusFacade status() {
        return wrapper.status();
    }
    @Override
    public T body() throws IOException {
        return wrapper.unpack(type);
    }
}
