/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.statemachine;

import com.turbospaces.statemachine.KycStatusEvents;
import com.turbospaces.statemachine.KycVerificationStates;
import java.util.Random;
import java.util.UUID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.messaging.support.MessageBuilder;
import org.springframework.statemachine.ExtendedState;
import org.springframework.statemachine.StateContext;
import org.springframework.statemachine.StateMachine;
import org.springframework.statemachine.action.Action;
import org.springframework.statemachine.config.EnableStateMachineFactory;
import org.springframework.statemachine.config.EnumStateMachineConfigurerAdapter;
import org.springframework.statemachine.config.StateMachineFactory;
import org.springframework.statemachine.config.builders.StateMachineStateConfigurer;
import org.springframework.statemachine.config.builders.StateMachineTransitionConfigurer;
import org.springframework.statemachine.config.configurers.ExternalTransitionConfigurer;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.context.TestExecutionListeners;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import reactor.core.publisher.Mono;

@ExtendWith(value={SpringExtension.class})
@ContextConfiguration(classes={AppConfig.class})
@TestExecutionListeners(mergeMode=TestExecutionListeners.MergeMode.MERGE_WITH_DEFAULTS, listeners={})
public class StateMachineTest {
    @Autowired
    private StateMachineFactory<KycVerificationStates, KycStatusEvents> stateMachineFactory;

    @Test
    public void works() {
        StateMachine m1 = this.stateMachineFactory.getStateMachine("demo");
        m1.startReactively().subscribe();
        m1.sendEvent(Mono.just((Object)MessageBuilder.withPayload((Object)((Object)KycStatusEvents.AFTER_SOME_INITIAL_EVENT)).setHeader("header-1", (Object)UUID.randomUUID().toString()).setHeader("header-2", (Object)UUID.randomUUID().toString()).build())).blockFirst();
        Assertions.assertEquals((Object)((Object)KycVerificationStates.PUBLIC_PAGE_REVIEW), (Object)m1.getState().getId());
    }

    @Configuration
    @EnableStateMachineFactory
    public static class AppConfig
    extends EnumStateMachineConfigurerAdapter<KycVerificationStates, KycStatusEvents> {
        private static final Logger log = LoggerFactory.getLogger(AppConfig.class);

        public void configure(StateMachineStateConfigurer<KycVerificationStates, KycStatusEvents> states) throws Exception {
            states.withStates().initial((Object)KycVerificationStates.INITIAL).state((Object)KycVerificationStates.PUBLIC_PAGE_REVIEW).state((Object)KycVerificationStates.DOC_REVIEW).end((Object)KycVerificationStates.CONFIRMED).end((Object)KycVerificationStates.DECLINED);
        }

        public void configure(StateMachineTransitionConfigurer<KycVerificationStates, KycStatusEvents> transitions) throws Exception {
            ((ExternalTransitionConfigurer)((ExternalTransitionConfigurer)transitions.withExternal().source((Object)KycVerificationStates.INITIAL)).target((Object)KycVerificationStates.PUBLIC_PAGE_REVIEW).event((Object)KycStatusEvents.AFTER_SOME_INITIAL_EVENT)).action((Action)new Action<KycVerificationStates, KycStatusEvents>(){

                public void execute(StateContext<KycVerificationStates, KycStatusEvents> context) {
                    KycVerificationStates source = (KycVerificationStates)((Object)context.getSource().getId());
                    KycVerificationStates target = (KycVerificationStates)((Object)context.getTarget().getId());
                    ExtendedState extendedState = context.getExtendedState();
                    log.info("applying an action source: {}, target: {}", (Object)source, (Object)target);
                    extendedState.getVariables().put("counter", new Random().nextInt());
                }
            });
        }
    }
}

