/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.util.concurrent.MoreExecutors;
import com.turbospaces.executor.PlatformExecutorService;
import com.turbospaces.executor.SerialContextWorker;
import io.netty.util.AsciiString;
import io.vavr.CheckedRunnable;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.MDC;
import org.springframework.util.CollectionUtils;

class MDCUtilTest {
    MDCUtilTest() {
    }

    @Test
    void empty() {
        try {
            Map mdc = MDC.getCopyOfContextMap();
            ImmutableMap toCleanUp = PlatformExecutorService.propagete((Map)mdc);
            PlatformExecutorService.cleanUp((ImmutableMap)toCleanUp);
        }
        finally {
            MDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void works() throws InterruptedException {
        try {
            MDC.put((String)"k1", (String)"v1");
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            ImmutableMap toCleanUp = PlatformExecutorService.propagete((Map)MDC.getCopyOfContextMap());
            SerialContextWorker worker = new SerialContextWorker(AsciiString.cached((String)"k1"), (ExecutorService)MoreExecutors.listeningDecorator((ExecutorService)threadPool));
            final CountDownLatch l1 = new CountDownLatch(1);
            worker.submit(new CheckedRunnable(){

                public void run() throws Throwable {
                    Assertions.assertEquals((Object)"v1", (Object)MDC.get((String)"k1"));
                    l1.countDown();
                }
            });
            Assertions.assertTrue((boolean)l1.await(30L, TimeUnit.SECONDS));
            PlatformExecutorService.cleanUp((ImmutableMap)toCleanUp);
            final CountDownLatch l2 = new CountDownLatch(1);
            worker.submit(new CheckedRunnable(){

                public void run() throws Throwable {
                    Map contextMap = MDC.getCopyOfContextMap();
                    System.out.println(contextMap);
                    Assertions.assertTrue((boolean)CollectionUtils.isEmpty((Map)contextMap));
                    l2.countDown();
                }
            });
            Assertions.assertTrue((boolean)l2.await(30L, TimeUnit.SECONDS));
        }
        finally {
            MDC.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void changed() throws InterruptedException {
        try {
            MDC.put((String)"k1", (String)"v1");
            MDC.put((String)"k2", (String)"v2");
            ExecutorService threadPool = Executors.newFixedThreadPool(1);
            SerialContextWorker worker = new SerialContextWorker(AsciiString.cached((String)"k1"), (ExecutorService)MoreExecutors.listeningDecorator((ExecutorService)threadPool));
            final CountDownLatch l = new CountDownLatch(1);
            worker.submit(new CheckedRunnable(){

                public void run() throws Throwable {
                    MDC.put((String)"k2", (String)"m2");
                    MDC.put((String)"k3", (String)"m3");
                    Assertions.assertEquals((Object)"m2", (Object)MDC.get((String)"k2"));
                    Assertions.assertEquals((Object)"m3", (Object)MDC.get((String)"k3"));
                    l.countDown();
                }
            });
            Assertions.assertTrue((boolean)l.await(30L, TimeUnit.SECONDS));
        }
        finally {
            MDC.clear();
        }
    }
}

