package com.turbospaces.boot;

import java.util.Objects;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.DestructionAwareBeanPostProcessor;
import org.springframework.context.ApplicationContextInitializer;
import org.springframework.context.ConfigurableApplicationContext;

public class InjectBootstrapContextInitializer implements ApplicationContextInitializer<ConfigurableApplicationContext> {
    private final Bootstrap bootstrap;

    public InjectBootstrapContextInitializer(Bootstrap bootstrap) {
        this.bootstrap = Objects.requireNonNull(bootstrap);
    }
    @Override
    public void initialize(ConfigurableApplicationContext ctx) {
        ConfigurableListableBeanFactory factory = ctx.getBeanFactory();
        factory.addBeanPostProcessor(new DestructionAwareBeanPostProcessor() {
            @Override
            public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof BootstrapAware) {
                    try {
                        ((BootstrapAware) bean).setBootstrap(bootstrap);
                    } catch (Exception err) {
                        throw new BeanCreationException(err.getMessage(), err);
                    }
                }
                return bean;
            }
            @Override
            public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
                if (bean instanceof BootstrapAware) {
                    try {
                        ((BootstrapAware) bean).setBootstrap(bootstrap);
                    } catch (Exception err) {
                        throw new BeanCreationException(err.getMessage(), err);
                    }
                }
                return bean;
            }
            @Override
            public void postProcessBeforeDestruction(Object bean, String beanName) throws BeansException {

            }
        });
    }
}
