/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.healthchecks;

import com.codahale.metrics.health.HealthCheck;
import com.turbospaces.boot.AbstractHealtchCheck;
import com.turbospaces.cfg.ApplicationProperties;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.springframework.cloud.service.common.RelationalServiceInfo;

public class RelationalHealthCheck
extends AbstractHealtchCheck {
    private final RelationalServiceInfo serviceInfo;
    private final Properties properties;

    public RelationalHealthCheck(ApplicationProperties props, RelationalServiceInfo serviceInfo) {
        this.serviceInfo = Objects.requireNonNull(serviceInfo);
        int timeout = (int)TimeUnit.SECONDS.toMillis(((Integer)props.JDBC_CONNECTION_TIMEOUT.get()).intValue());
        this.properties = new Properties();
        this.properties.put("connectTimeout", (Object)timeout);
        if (serviceInfo.getUserName() != null) {
            this.properties.put("user", serviceInfo.getUserName());
        }
        if (serviceInfo.getPassword() != null) {
            this.properties.put("password", serviceInfo.getPassword());
        }
    }

    protected HealthCheck.Result check() throws Exception {
        HealthCheck.Result result;
        block8: {
            this.logger.debug("checking JDBC connectivity on {}:{} ...", (Object)this.serviceInfo.getHost(), (Object)this.serviceInfo.getPort());
            String jdbcUrl = this.serviceInfo.getJdbcUrl();
            Driver driver = DriverManager.getDriver(jdbcUrl);
            Connection connection = driver.connect(jdbcUrl, this.properties);
            try {
                String productVersion = connection.getMetaData().getDatabaseProductVersion();
                result = HealthCheck.Result.healthy((String)("db version: " + productVersion));
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception err) {
                    this.logger.warn(err.getMessage(), (Throwable)err);
                    return HealthCheck.Result.unhealthy((Throwable)err);
                }
            }
            connection.close();
        }
        return result;
    }

    @Override
    public boolean isBootstrapOnly() {
        return false;
    }

    public void destroy() throws Exception {
    }
}

