package com.turbospaces.healthchecks;

import java.util.List;
import java.util.Optional;
import java.util.SortedMap;
import java.util.concurrent.atomic.AtomicBoolean;

import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;

import com.codahale.metrics.health.HealthCheck;
import com.turbospaces.boot.AbstractBootstrapAware;

public class AdminComponent extends AbstractBootstrapAware implements ApplicationListener<ApplicationReadyEvent> {
    private final AtomicBoolean ready = new AtomicBoolean();

    public Optional<String> version(List<String> xForwardedFor) {
        if (appIsReady() && (xForwardedFor == null || xForwardedFor.isEmpty())) {
            return Optional.of(bootstrap.release());
        }

        return Optional.empty();
    }

    public int healthCheck(List<String> xForwardedFor) {
        if (appIsReady() && xForwardedFor.isEmpty()) {
            SortedMap<String, HealthCheck.Result> results = bootstrap.healthCheckRegistry().runHealthChecks();
            for (HealthCheck.Result result : results.values()) {
                if (!result.isHealthy()) {
                    logger.error(result.getMessage());
                    return 500;
                }
            }
            return 200;
        }
        return 403;
    }

    @Override
    public void onApplicationEvent(ApplicationReadyEvent event) {
        this.ready.set(true);
    }

    private boolean appIsReady() {
        return ready.get();
    }
}
