package com.turbospaces.rpc;

import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;

import com.google.common.util.concurrent.FluentFuture;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.turbospaces.api.facade.RequestWrapperFacade;
import com.turbospaces.api.facade.ResponseWrapperFacade;

import api.v1.ReplyUtil;
import lombok.experimental.Delegate;

public class DefaultWrappedQueuePost implements WrappedQueuePost {
    @Delegate
    private final FluentFuture<ResponseWrapperFacade> subject;
    private final RequestWrapperFacade requestWrapper;

    public DefaultWrappedQueuePost(ListenableFuture<ResponseWrapperFacade> future, RequestWrapperFacade requestWrapper) {
        this.subject = FluentFuture.from(future);
        this.requestWrapper = Objects.requireNonNull(requestWrapper);
    }
    @Override
    public RequestWrapperFacade requestWrapper() {
        return requestWrapper;
    }
    @Override
    public void addCallback(FutureCallback<ResponseWrapperFacade> callback, Executor executor) {
        subject.addCallback(callback, executor);
    }
    @Override
    public WrappedQueuePost thenVerifyOk(Executor executor) {
        return thenVerifyOkAndAccept(new Consumer<ResponseWrapperFacade>() {
            @Override
            public void accept(ResponseWrapperFacade t) {

            }
        });
    }
    @Override
    public WrappedQueuePost thenVerifyOkAndAccept(Consumer<ResponseWrapperFacade> callback, Executor executor) {
        SettableFuture<ResponseWrapperFacade> toReturn = SettableFuture.create();
        subject.addCallback(new FutureCallback<ResponseWrapperFacade>() {
            @Override
            public void onSuccess(ResponseWrapperFacade result) {
                try {
                    ReplyUtil.verifyOk(result);
                } catch (Exception err) {
                    toReturn.setException(err);
                }

                try {
                    callback.accept(result);
                    toReturn.set(result);
                } catch (Exception err) {
                    toReturn.setException(err);
                }
            }
            @Override
            public void onFailure(Throwable t) {
                toReturn.setException(t);
            }
        }, executor);

        //
        // ~ new API response by contract
        //
        return new DefaultWrappedQueuePost(toReturn, requestWrapper);
    }
}
