package com.turbospaces.cfg;

import static java.util.concurrent.TimeUnit.MINUTES;

import java.net.MalformedURLException;
import java.net.URL;
import java.time.Duration;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import com.netflix.archaius.api.Property;
import com.turbospaces.common.PlatformUtil;

import reactor.core.scheduler.Scheduler;
import reactor.util.retry.Retry;

public class ApplicationProperties {
    public static final int DEFAULT_PORT = 8089;
    //
    // prefixes
    //
    public static final String NETTY_PREFIX = "netty.";
    public static final String JETTY_PREFIX = "jetty.";
    public static final String QUARTZ_PREFIX = "quartz.";
    public static final String JDBC_PREFIX = "jdbc.";
    public static final String FLINK_PREFIX = "flink.";
    public static final String KAFKA_PREFIX = "kafka.";
    public static final String ZK_PREFIX = "zk.";
    public static final String TCP_PREFIX = "tcp.";
    public static final String APP_PREFIX = "app.";
    public static final String REDIS_PREFIX = "redis.";
    public static final String HTTP_PREFIX = "http.";
    public static final String CACHE_PREFIX = "cache.";
    //
    //
    //
    public static final String USERNAME = System.getProperty( "user.name" );
    public static final String TMP_DIR = System.getProperty( "java.io.tmpdir" );

    //
    // common application properties
    //
    public static final String APP_DEV_MODE_KEY = APP_PREFIX + "dev.mode";
    public static final String APP_DNS_QUERY_KEY = APP_PREFIX + "dns.query";
    public static final String APP_BACKOFF_RETRY_FIRST_KEY = APP_PREFIX + "backoff-retry.first";
    public static final String APP_BACKOFF_RETRY_MAX_KEY = APP_PREFIX + "backoff-retry.max";
    public static final String APP_BACKOFF_RETRY_NUM_KEY = APP_PREFIX + "backoff-retry.num";
    public static final String APP_SENTRY_ENABLED_KEY = APP_PREFIX + "sentry.enabled";
    public static final String APP_USE_SELF_SIGNED_CERTIFICATE_KEY = APP_PREFIX + "use.self-signed-certificate";
    public static final String APP_LOGGING_RESET_TO_KEY = APP_PREFIX + "logging.reset-to";
    public static final String APP_LOGGING_DRY_RUN_KEY = APP_PREFIX + "logging.dry-run";
    public static final String APP_METRICS_DRY_RUN_KEY = APP_PREFIX + "metrics.dry-run";
    public static final String APP_METRICS_ELK_REPORTER_ENABLED_KEY = APP_PREFIX + "metrics.elk-reporter.enabled";
    public static final String APP_METRICS_INFLUX_REPORTER_ENABLED_KEY = APP_PREFIX + "metrics.influx-reporter.enabled";
    public static final String APP_METRICS_PROMETHEUS_REPORTER_ENABLED_KEY = APP_PREFIX + "metrics.prometheus-reporter.enabled";
    public static final String APP_ALERTS_DRY_RUN_KEY = APP_PREFIX + "alerts.dry-run";
    public static final String APP_EXTERNAL_IP_KEY = APP_PREFIX + "external.ip";
    public static final String APP_JMX_DOMAIN_KEY = APP_PREFIX + "jmx.domain";
    public static final String APP_ALLOWED_ORIGINS_KEY = APP_PREFIX + "allowed-origins";
    public static final String APP_BASIC_AUTH_KEY = APP_PREFIX + "basic-auth";
    public static final String APP_DB_MIGRATION_ENABLED_KEY = APP_PREFIX + "db-migration.enabled";
    public static final String APP_DB_MIGRATION_PATH_KEY = APP_PREFIX + "db-migration.path";
    public static final String APP_CONTRACTS_MIGRATION_ENABLED_KEY = APP_PREFIX + "contracts-migration.enabled";
    public static final String APP_GRACEFUL_SHUTDOWN_TIMEOUNT_KEY = APP_PREFIX + "graceful-shutdown.timeout";
    public static final String APP_PLATFORM_POOL_SIZE_KEY = APP_PREFIX + "platform.pool-size";
    public static final String APP_PLATFORM_MAX_IDLE_KEY = APP_PREFIX + "platform.max-idle";
    public static final String APP_PLATFORM_GRACEFUL_TIMEOUT_KEY = APP_PREFIX + "platform.graceful-shutdown-timeout";
    public static final String APP_TIMER_INTERVAL_KEY = APP_PREFIX + "timer.interval";
    public static final String APP_METRICS_BULK_SIZE_KEY = APP_PREFIX + "metrics.bulk-size";
    public static final String APP_EXPONENTIAL_BACKOFF_KEY = APP_PREFIX + "exponential.backoff";
    public static final String APP_REPLICATOR_MAX_RETRIES_KEY = APP_PREFIX + "replicator.max-retries";
    public static final String APP_REPLICATOR_NAMESPACES_KEY = APP_PREFIX + "replicator.namespaces";
    public static final String APP_REPLICATOR_FETCH_SIZE_KEY = APP_PREFIX + "replicator.fetch-size";
    public static final String APP_REPLICATOR_MAX_ATTEMPT_PER_SECOND_KEY = APP_PREFIX + "replicator.max-attempts-per-second";
    public static final String APP_REPLICATION_DIR_KEY = APP_PREFIX + "replication.dir";
    public static final String APP_REPLICATOR_FILES_TTL_KEY = APP_PREFIX + "replicator.files-ttl";
    public static final String APP_REPLICATOR_START_CLEAN_KEY = APP_PREFIX + "replicator.start-clean";
    public static final String APP_HEAP_DUMP_ON_OOM_ENABLED_KEY = APP_PREFIX + "heap-dump-on-oom.enabled";
    public static final String APP_HEAP_DUMP_DIR_KEY = APP_PREFIX + "heap-dump.dir";
    public static final String APP_WAIT_FOR_HEALTHCHECKS_INTERVAL_KEY = APP_PREFIX + "wait-for-healthchecks.interval";
    public static final String APP_WAIT_FOR_HEALTHCHECKS_ENABLED_KEY = APP_PREFIX + "wait-for-healthchecks.enabled";
    public static final String APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT_KEY = APP_PREFIX + "wait-for-healthchecks.timeout";
    public static final String APP_DATA_START_CLEAN_KEY = APP_PREFIX + "data.start-clean";
    public static final String APP_SHUTDOWN_HOOK_ENABLED_KEY = APP_PREFIX + "shutdown-hook.enabled";
    public static final String APP_CLEAR_CFG_AT_SHUTDOWN_ENABLED_KEY = APP_PREFIX + "clear-config-at-shutdown.enabled";
    public static final String APP_CFG_DYNAMIC_POLLING_ENABLED_KEY = APP_PREFIX + "cfg-dynamic-polling.enabled";

    //
    // HTTP

    public static final String HTTP_POOL_MIN_SIZE_KEY = HTTP_PREFIX + "pool.min-size";//
    public static final String HTTP_POOL_MAX_SIZE_KEY = HTTP_PREFIX + "pool.max-size";

    //
    // redis
    //
    public static final String REDIS_POOL_MIN_SIZE_KEY = REDIS_PREFIX + "pool.min-size";
    public static final String REDIS_POOL_MAX_SIZE_KEY = REDIS_PREFIX + "pool.max-size";

    //
    // TCP
    //
    public static final String TCP_REUSE_ADDRESS_KEY = TCP_PREFIX + "reuse-address";
    public static final String TCP_NODELAY_KEY = TCP_PREFIX + "no-delay";
    public static final String TCP_KEEP_ALIVE_KEY = TCP_PREFIX + "keep-alive";
    public static final String TCP_KEEP_ALIVE_TIMEOUT_KEY = TCP_PREFIX + "keep-alive.timeout";
    public static final String TCP_CONNECTION_TIMEOUT_KEY = TCP_PREFIX + "connection.timeout";
    public static final String TCP_SOCKET_TIMEOUT_KEY = TCP_PREFIX + "socket.timeout";
    public static final String TCP_SOCKET_BACKLOG_KEY = TCP_PREFIX + "socket.backlog";
    public static final String TCP_MAX_FRAME_SIZE_KEY = TCP_PREFIX + "max-frame-size";

    //
    // curator/zookeeper
    //
    public static final String ZK_SESSION_TIMEOUT_KEY = ZK_PREFIX + "session.timeout";
    public static final String ZK_CONNECT_TIMEOUT_KEY = ZK_PREFIX + "connect.timeout";
    public static final String ZK_RETRY_INITIAL_KEY = ZK_PREFIX + "retry.initial";
    public static final String ZK_RETRY_MAX_KEY = ZK_PREFIX + "retry.max";

    //
    // netty
    //
    public static final String NETTY_ACCEPTOR_POOL_SIZE_KEY = NETTY_PREFIX + "acceptor-pool.size";
    public static final String NETTY_WORKER_POOL_SIZE_KEY = NETTY_PREFIX + "worker-pool.size";

    //
    // jetty
    //
    public static final String JETTY_POOL_MAX_SIZE_KEY = JETTY_PREFIX + "pool.max-size";
    public static final String JETTY_POOL_MIN_SIZE_KEY = JETTY_PREFIX + "pool.min-size";
    public static final String JETTY_POOL_QUEUE_MAX_SIZE_KEY = JETTY_PREFIX + "pool.queue-max-size";
    public static final String JETTY_POOL_IDLE_KEY = JETTY_PREFIX + "pool.max-idle";
    public static final String JETTY_HTTP_SEND_DATE_HEADER_KEY = JETTY_PREFIX + "http.send-date-header";
    public static final String JETTY_GZIP_ENABLED_KEY = JETTY_PREFIX + "gzip.enabled";
    public static final String JETTY_GZIP_MIN_RESPONSE_SIZE_KEY = JETTY_PREFIX + "gzip.min-response-size";

    //
    // flink
    //
    public static final String FLINK_DEFAULT_PARALLELISM_KEY = FLINK_PREFIX + "default.parallelism";
    public static final String FLINK_CHECKPOINT_ENABLED_KEY = FLINK_PREFIX + "checkpoint.enabled";
    public static final String FLINK_CHECKPOINT_INTERVAL_KEY = FLINK_PREFIX + "checkpoint.interval";
    public static final String FLINK_CHECKPOINT_TIMEOUT_KEY = FLINK_PREFIX + "checkpoint.timeout";
    public static final String FLINK_CHECKPOINT_MAX_CONCURRENT_KEY = FLINK_PREFIX + "checkpoint.max-concurrent";
    public static final String FLINK_CHECKPOINT_MAX_RESTART_ATTEMPTS_KEY = FLINK_PREFIX + "checkpoint.max-restart-attempts";
    public static final String FLINK_CHECKPOINT_DELAY_BETWEEN_ATTEMPTS_KEY = FLINK_PREFIX + "checkpoint.delay-between-attempts";
    public static final String FLINK_STATE_BACKEND_PATH_KEY = FLINK_PREFIX + "state-backend.path";

    //
    // kafka
    //
    public static final String KAFKA_POLL_TIMEOUT_KEY = KAFKA_PREFIX + "poll.timeout";
    public static final String KAFKA_MAX_BLOCK_KEY = KAFKA_PREFIX + "max-block";
    public static final String KAFKA_ENABLE_IDEMPOTENCE_KEY = KAFKA_PREFIX + "enable.idempotence";
    public static final String KAFKA_ACKS_KEY = KAFKA_PREFIX + "acks";
    public static final String KAFKA_COMPRESSION_TYPE_KEY = KAFKA_PREFIX + "compression.type";
    public static final String KAFKA_MAX_REQUEST_SIZE_KEY = KAFKA_PREFIX + "max.request.size";
    public static final String KAFKA_AUTO_OFFSET_RESET_KEY = KAFKA_PREFIX + "auto.offset.reset";
    public static final String KAFKA_HEARTBEAT_INTERVAL_KEY = KAFKA_PREFIX + "heartbeat.interval";
    public static final String KAFKA_SESSION_TIMEOUT_KEY = KAFKA_PREFIX + "session.timeout";
    public static final String KAFKA_POLL_MAX_INTERVAL_KEY = KAFKA_PREFIX + "poll.max-interval";
    public static final String KAFKA_POLL_MAX_RECORDS_KEY = KAFKA_PREFIX + "poll.max-records";
    public static final String KAFKA_POLL_MAX_RATE_KEY = KAFKA_PREFIX + "poll.rate";
    public static final String KAFKA_QUEUE_MAX_SIZE_KEY = KAFKA_PREFIX + "queue.max-size";
    public static final String KAFKA_MAX_WORKERS_KEY = KAFKA_PREFIX + "max-workers";

    //
    // quartz
    //
    public static final String QUARTZ_SCHEDULER_NAME_KEY = QUARTZ_PREFIX + "scheduler.name";
    public static final String QUARTZ_SCHEDULER_ID_KEY = QUARTZ_PREFIX + "scheduler.id";
    public static final String QUARTZ_SCHEDULER_POOL_COUNT_KEY = QUARTZ_PREFIX + "worker-pool.count";
    public static final String QUARTZ_JOBSTORE_TABLE_PREFIX_KEY = QUARTZ_PREFIX + "jobstore.table-prefix";
    public static final String QUARTZ_JOBSTORE_USE_PROPS_KEY = QUARTZ_PREFIX + "jobstore.use-props";
    public static final String QUARTZ_JOBSTORE_ACQUIRE_TRIGGERS_WITHIN_LOCK_KEY = QUARTZ_PREFIX + "jobstore.acquire-triggers-within-lock";
    public static final String QUARTZ_JOBSTORE_IS_CLUSTERED_KEY = QUARTZ_PREFIX + "jobstore.is-clustered";
    public static final String QUARTZ_CONNECTION_POOL_MIN_KEY = QUARTZ_PREFIX + "connection-pool.min";
    public static final String QUARTZ_CONNECTION_POOL_MAX_KEY = QUARTZ_PREFIX + "connection-pool.max";
    public static final String QUARTZ_INSTANCE_ID_KEY = QUARTZ_PREFIX + "instance.id";
    public static final String QUARTZ_AUTO_RECOVERY_INTERVAL_KEY = QUARTZ_PREFIX + "auto-recovery.interval";

    //
    // JDBC
    //
    public static final String JDBC_PERSIST_BATCH_SIZE_KEY = JDBC_PREFIX + "persist-batch.size";
    public static final String JDBC_QUERY_BATCH_SIZE_KEY = JDBC_PREFIX + "query-batch.size";
    public static final String JDBC_LAZY_BATCH_SIZE_KEY = JDBC_PREFIX + "lazy-batch.size";
    public static final String JDBC_LAZY_SEQUENCE_BATCH_SIZE_KEY = JDBC_PREFIX + "lazy-sequence-batch.size";
    public static final String JDBC_CONNECTION_TIMEOUT_KEY = JDBC_PREFIX + "connection.timeout";
    public static final String JDBC_DEFAULT_INSTANCE_KEY = JDBC_PREFIX + "default.instance";
    public static final String JDBC_CONNECTION_POOL_MIN_SIZE_KEY = JDBC_PREFIX + "pool.min-size";
    public static final String JDBC_CONNECTION_POOL_MAX_SIZE_KEY = JDBC_PREFIX + "pool.max-size";
    public static final String JDBC_READ_ONLY_CONNECTION_POOL_MIN_SIZE_KEY = JDBC_PREFIX + "read-only-pool.min-size";
    public static final String JDBC_READ_ONLY_CONNECTION_POOL_MAX_SIZE_KEY = JDBC_PREFIX + "read-only-pool.max-size";

    //
    // cache
    //
    public static final String CACHE_DEFAULT_MAX_TTL_KEY = CACHE_PREFIX + "default.max-ttl";
    public static final String CACHE_DEFAULT_MAX_IDLE_KEY = CACHE_PREFIX + "default.max-idle";
    public static final String CACHE_DEFAULT_MAX_SIZE_KEY = CACHE_PREFIX + "default.max-size";
    public static final String CACHE_REPLICATED_NEVER_EXPIRE_KEY = CACHE_PREFIX + "replicated.never-expire";
    public static final String CACHE_LOCAL_NEVER_EXPIRE_KEY = CACHE_PREFIX + "local.never-expire";

    public ApplicationProperties(ApplicationConfig cfg) {
        this.cfg = Objects.requireNonNull( cfg );
        DynamicPropertyFactory pf = cfg.factory();

        //
        //
        CLOUD_APP_ID = pf.get( CloudOptions.CLOUD_APP_ID, String.class ).orElse( USERNAME );
        CLOUD_APP_INSTANCE_INDEX = pf.get( CloudOptions.CLOUD_APP_INSTANCE_INDEX, String.class ).orElse( "0" );
        CLOUD_APP_NAME = pf.get( CloudOptions.CLOUD_APP_NAME, String.class );
        CLOUD_APP_SPACE_NAME = pf.get( CloudOptions.CLOUD_APP_SPACE_NAME, String.class );
        CLOUD_APP_HOST = pf.get( CloudOptions.CLOUD_APP_HOST, String.class ).orElse( "localhost" );
        CLOUD_APP_PORT = pf.get( CloudOptions.CLOUD_APP_PORT, int.class ).orElse( DEFAULT_PORT );

        //
        // TCP
        //
        TCP_REUSE_ADDRESS = pf.get( TCP_REUSE_ADDRESS_KEY, boolean.class ).orElse( true );
        TCP_NODELAY = pf.get( TCP_NODELAY_KEY, boolean.class ).orElse( true );
        TCP_KEEP_ALIVE = pf.get( TCP_KEEP_ALIVE_KEY, boolean.class ).orElse( true );
        TCP_KEEP_ALIVE_TIMEOUT = pf.get( TCP_KEEP_ALIVE_TIMEOUT_KEY, int.class ).orElse( 30 ); // s
        TCP_CONNECTION_TIMEOUT = pf.get( TCP_CONNECTION_TIMEOUT_KEY, int.class ).orElse( 10 ); // s
        TCP_SOCKET_TIMEOUT = pf.get( TCP_SOCKET_TIMEOUT_KEY, int.class ).orElse( 60 ); // s
        TCP_SOCKET_BACKLOG = pf.get( TCP_SOCKET_BACKLOG_KEY, int.class ).orElse( 1024 );
        TCP_MAX_FRAME_SIZE = pf.get( TCP_MAX_FRAME_SIZE_KEY, int.class ).orElse( 1024 * 1024 * 16 ); // 16MB

        //
        // APP
        //
        APP_DEV_MODE = pf.get( APP_DEV_MODE_KEY, boolean.class ).orElse( true );
        APP_DNS_QUERY = pf.get( APP_DNS_QUERY_KEY, String.class );
        APP_BACKOFF_RETRY_FIRST = pf.get( APP_BACKOFF_RETRY_FIRST_KEY, int.class ).orElse( 1 ); // s
        APP_BACKOFF_RETRY_MAX = pf.get( APP_BACKOFF_RETRY_MAX_KEY, int.class ).orElse( 30 ); // s
        APP_BACKOFF_RETRY_NUM = pf.get( APP_BACKOFF_RETRY_NUM_KEY, int.class ).orElse( 10 );
        APP_SENTRY_ENABLED = pf.get( APP_SENTRY_ENABLED_KEY, boolean.class ).orElse( true );
        APP_USE_SELF_SIGNED_CERTIFICATE = pf.get( APP_USE_SELF_SIGNED_CERTIFICATE_KEY, Boolean.class ).orElse( false );
        APP_LOGGING_RESET_TO = pf.get( APP_LOGGING_RESET_TO_KEY, String.class );
        APP_LOGGING_DRY_RUN = pf.get( APP_LOGGING_DRY_RUN_KEY, boolean.class ).orElse( false );
        APP_METRICS_DRY_RUN = pf.get( APP_METRICS_DRY_RUN_KEY, boolean.class ).orElse( false );
        APP_METRICS_ELK_REPORTER_ENABLED = pf.get( APP_METRICS_ELK_REPORTER_ENABLED_KEY, boolean.class ).orElse( false );
        APP_METRICS_INFLUX_REPORTER_ENABLED = pf.get( APP_METRICS_INFLUX_REPORTER_ENABLED_KEY, boolean.class ).orElse( false );
        APP_METRICS_PROMETHEUS_REPORTER_ENABLED = pf.get( APP_METRICS_PROMETHEUS_REPORTER_ENABLED_KEY, boolean.class ).orElse( false );
        APP_ALERTS_DRY_RUN = pf.get( APP_ALERTS_DRY_RUN_KEY, boolean.class ).orElse( false );
        APP_EXTERNAL_IP = pf.get( APP_EXTERNAL_IP_KEY, String.class ).orElse( PlatformUtil.fetchExternalIp( this ) );
        APP_JMX_DOMAIN = pf.get( APP_JMX_DOMAIN_KEY, String.class ).orElse( "metrics" );
        APP_ALLOWED_ORIGINS = pf.get( APP_ALLOWED_ORIGINS_KEY, String.class );
        APP_BASIC_AUTH = pf.get( APP_BASIC_AUTH_KEY, String.class );
        APP_DB_MIGRATION_ENABLED = pf.get( APP_DB_MIGRATION_ENABLED_KEY, boolean.class ).orElse( true );
        APP_DB_MIGRATION_PATH = pf.get( APP_DB_MIGRATION_PATH_KEY, String.class ).orElse( "db/sql-migration" );
        APP_CONTRACTS_MIGRATION_ENABLED = pf.get( APP_CONTRACTS_MIGRATION_ENABLED_KEY, boolean.class ).orElse( true );
        APP_GRACEFUL_SHUTDOWN_TIMEOUNT = pf.get( APP_GRACEFUL_SHUTDOWN_TIMEOUNT_KEY, int.class ).orElse( 45 ); // s
        APP_PLATFORM_POOL_SIZE = pf.get( APP_PLATFORM_POOL_SIZE_KEY, int.class ).orElse( 64 );
        APP_PLATFORM_MAX_IDLE = pf.get( APP_PLATFORM_MAX_IDLE_KEY, int.class ).orElse( 10 ); // s
        APP_PLATFORM_GRACEFUL_TIMEOUT = pf.get( APP_PLATFORM_GRACEFUL_TIMEOUT_KEY, int.class ).orElse( 30 );
        APP_TIMER_INTERVAL = pf.get( APP_TIMER_INTERVAL_KEY, int.class ).orElse( 15 ); // s
        APP_METRICS_BULK_SIZE = pf.get( APP_METRICS_BULK_SIZE_KEY, int.class ).orElse( 1024 ); // s
        APP_EXPONENTIAL_BACKOFF = pf.get( APP_EXPONENTIAL_BACKOFF_KEY, double.class ).orElse( 1.2 );
        APP_REPLICATOR_MAX_RETRIES = pf.get( APP_REPLICATOR_MAX_RETRIES_KEY, int.class ).orElse( 256 );
        APP_REPLICATOR_NAMESPACES = pf.get( APP_REPLICATOR_NAMESPACES_KEY, String.class ).orElse( USERNAME );
        APP_REPLICATOR_FETCH_SIZE = pf.get( APP_REPLICATOR_FETCH_SIZE_KEY, int.class ).orElse( 256 );
        APP_REPLICATOR_MAX_ATTEMPT_PER_SECOND = pf.get( APP_REPLICATOR_MAX_ATTEMPT_PER_SECOND_KEY, int.class ).orElse( 10 );
        APP_REPLICATION_DIR = pf.get( APP_REPLICATION_DIR_KEY, String.class ).orElse( TMP_DIR );
        APP_REPLICATOR_FILES_TTL = pf.get( APP_REPLICATOR_FILES_TTL_KEY, int.class ).orElse( 24 * 7 ); // h
        APP_REPLICATOR_START_CLEAN = pf.get( APP_REPLICATOR_START_CLEAN_KEY, boolean.class ).orElse( false );
        APP_HEAP_DUMP_ON_OOM_ENABLED = pf.get( APP_HEAP_DUMP_ON_OOM_ENABLED_KEY, boolean.class ).orElse( true );
        APP_HEAP_DUMP_DIR = pf.get( APP_HEAP_DUMP_DIR_KEY, String.class ).orElse( TMP_DIR );
        APP_WAIT_FOR_HEALTHCHECKS_INTERVAL = pf.get( APP_WAIT_FOR_HEALTHCHECKS_INTERVAL_KEY, int.class ).orElse( 1 ); // s
        APP_WAIT_FOR_HEALTHCHECKS_ENABLED = pf.get( APP_WAIT_FOR_HEALTHCHECKS_ENABLED_KEY, boolean.class ).orElse( false );
        APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT = pf.get( APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT_KEY, int.class ).orElse( 60 ); // s
        APP_DATA_START_CLEAN = pf.get( APP_DATA_START_CLEAN_KEY, boolean.class ).orElse( false );
        APP_SHUTDOWN_HOOK_ENABLED = pf.get( APP_SHUTDOWN_HOOK_ENABLED_KEY, boolean.class ).orElse( true );
        APP_CLEAR_CFG_AT_SHUTDOWN_ENABLED = pf.get( APP_CLEAR_CFG_AT_SHUTDOWN_ENABLED_KEY, boolean.class ).orElse( false );
        APP_CFG_DYNAMIC_POLLING_ENABLED = pf.get( APP_CFG_DYNAMIC_POLLING_ENABLED_KEY, boolean.class ).orElse( true );

        //
        // HTTP
        //
        HTTP_POOL_MIN_SIZE = pf.get( HTTP_POOL_MIN_SIZE_KEY, int.class ).orElse( 1 );
        HTTP_POOL_MAX_SIZE = pf.get( HTTP_POOL_MAX_SIZE_KEY, int.class ).orElse( 50 );

        //
        // REDIS
        //
        REDIS_POOL_MIN_SIZE = pf.get( REDIS_POOL_MIN_SIZE_KEY, int.class ).orElse( 16 );
        REDIS_POOL_MAX_SIZE = pf.get( REDIS_POOL_MAX_SIZE_KEY, int.class ).orElse( 64 );

        //
        // ZOOKEEPER
        //
        ZK_SESSION_TIMEOUT = pf.get( ZK_SESSION_TIMEOUT_KEY, int.class ).orElse( 15 ); // s
        ZK_RETRY_INITIAL = pf.get( ZK_RETRY_INITIAL_KEY, int.class ).orElse( 1 );
        ZK_RETRY_MAX = pf.get( ZK_RETRY_MAX_KEY, int.class ).orElse( 4 );

        //
        // NETTY
        //
        NETTY_ACCEPTOR_POOL_SIZE = pf.get( NETTY_ACCEPTOR_POOL_SIZE_KEY, int.class ).orElse( 1 );
        NETTY_WORKER_POOL_SIZE = pf.get( NETTY_WORKER_POOL_SIZE_KEY, int.class ).orElse( 32 );

        //
        // JETTY
        //
        JETTY_POOL_MAX_SIZE = pf.get( JETTY_POOL_MAX_SIZE_KEY, int.class ).orElse( 64 );
        JETTY_POOL_MIN_SIZE = pf.get( JETTY_POOL_MIN_SIZE_KEY, int.class ).orElse( 32 );
        JETTY_POOL_QUEUE_MAX_SIZE = pf.get( JETTY_POOL_QUEUE_MAX_SIZE_KEY, int.class ).orElse( 16 * 1024 );
        JETTY_POOL_IDLE = pf.get( JETTY_POOL_IDLE_KEY, int.class ).orElse( (int) MINUTES.toSeconds( 5 ) ); // s
        JETTY_HTTP_SEND_DATE_HEADER = pf.get( JETTY_HTTP_SEND_DATE_HEADER_KEY, boolean.class ).orElse( false );
        JETTY_GZIP_ENABLED = pf.get( JETTY_GZIP_ENABLED_KEY, boolean.class ).orElse( true );
        JETTY_GZIP_MIN_RESPONSE_SIZE = pf.get( JETTY_GZIP_MIN_RESPONSE_SIZE_KEY, int.class ).orElse( 2 * 1024 );

        //
        // FLINK
        //
        FLINK_DEFAULT_PARALLELISM = pf.get( FLINK_DEFAULT_PARALLELISM_KEY, int.class ).orElse( -1 );
        FLINK_CHECKPOINT_ENABLED = pf.get( FLINK_CHECKPOINT_ENABLED_KEY, boolean.class ).orElse( true );
        FLINK_CHECKPOINT_INTERVAL = pf.get( FLINK_CHECKPOINT_INTERVAL_KEY, int.class ).orElse( 10 ); // s
        FLINK_CHECKPOINT_TIMEOUT = pf.get( FLINK_CHECKPOINT_TIMEOUT_KEY, int.class ).orElse( (int) TimeUnit.MINUTES.toSeconds( 1 ) ); // s
        FLINK_CHECKPOINT_MAX_CONCURRENT = pf.get( FLINK_CHECKPOINT_MAX_CONCURRENT_KEY, int.class ).orElse( 1 );
        FLINK_CHECKPOINT_MAX_RESTART_ATTEMPTS = pf.get( FLINK_CHECKPOINT_MAX_RESTART_ATTEMPTS_KEY, int.class ).orElse( 30 );
        FLINK_CHECKPOINT_DELAY_BETWEEN_ATTEMPTS = pf.get( FLINK_CHECKPOINT_DELAY_BETWEEN_ATTEMPTS_KEY, int.class ).orElse( 1 ); // s
        FLINK_STATE_BACKEND_PATH = pf.get( FLINK_STATE_BACKEND_PATH_KEY, String.class );

        //
        // KAFKA
        //
        KAFKA_MAX_BLOCK = pf.get( KAFKA_MAX_BLOCK_KEY, int.class ).orElse( 30 ); // s
        KAFKA_ENABLED_IDEMPOTENCE = pf.get( KAFKA_ENABLE_IDEMPOTENCE_KEY, boolean.class ).orElse( true );
        KAFKA_ACKS = pf.get( KAFKA_ACKS_KEY, String.class ).orElse( "all" );
        KAFKA_COMPRESSION_TYPE = pf.get( KAFKA_COMPRESSION_TYPE_KEY, String.class ).orElse( "none" );
        KAFKA_MAX_REQUEST_SIZE = pf.get( KAFKA_MAX_REQUEST_SIZE_KEY, int.class ).orElse( 4 * 1024 * 1024 );
        KAFKA_AUTO_OFFSET_RESET = pf.get( KAFKA_AUTO_OFFSET_RESET_KEY, String.class );
        KAFKA_HEARTBEAT_INTERVAL = pf.get( KAFKA_HEARTBEAT_INTERVAL_KEY, int.class ).orElse( 5 ); // s
        KAFKA_SESSION_TIMEOUT = pf.get( KAFKA_SESSION_TIMEOUT_KEY, int.class ).orElse( 30 ); // s
        KAFKA_POLL_MAX_INTERVAL = pf.get( KAFKA_POLL_MAX_INTERVAL_KEY, int.class ).orElse( 10 * 60 ); // s
        KAFKA_POLL_MAX_RECORDS = pf.get( KAFKA_POLL_MAX_RECORDS_KEY, int.class ).orElse( 1024 );
        KAFKA_QUEUE_MAX_SIZE = pf.get( KAFKA_QUEUE_MAX_SIZE_KEY, int.class ).orElse( 1024 );
        KAFKA_MAX_WORKERS = pf.get( KAFKA_MAX_WORKERS_KEY, int.class ).orElse( 64 );

        //
        // QUARTZ
        //
        QUARTZ_SCHEDULER_ID = pf.get( QUARTZ_SCHEDULER_ID_KEY, String.class ).orElse( "AUTO" );
        QUARTZ_SCHEDULER_POOL_COUNT = pf.get( QUARTZ_SCHEDULER_POOL_COUNT_KEY, Integer.class ).orElse( 8 );
        QUARTZ_JOBSTORE_TABLE_PREFIX = pf.get( QUARTZ_JOBSTORE_TABLE_PREFIX_KEY, String.class ).orElse( "qrtz_" );
        QUARTZ_JOBSTORE_USE_PROPS = pf.get( QUARTZ_JOBSTORE_USE_PROPS_KEY, Boolean.class ).orElse( false );
        QUARTZ_JOBSTORE_ACQUIRE_TRIGGERS_WITHIN_LOCK = pf.get( QUARTZ_JOBSTORE_ACQUIRE_TRIGGERS_WITHIN_LOCK_KEY, Boolean.class ).orElse( false );
        QUARTZ_JOBSTORE_IS_CLUSTERED = pf.get( QUARTZ_JOBSTORE_IS_CLUSTERED_KEY, Boolean.class ).orElse( false );
        QUARTZ_CONNECTION_POOL_MIN = pf.get( QUARTZ_CONNECTION_POOL_MIN_KEY, Integer.class ).orElse( 1 );
        QUARTZ_CONNECTION_POOL_MAX = pf.get( QUARTZ_CONNECTION_POOL_MAX_KEY, Integer.class ).orElse( 5 );
        QUARTZ_INSTANCE_ID = pf.get( QUARTZ_INSTANCE_ID_KEY, String.class );
        QUARTZ_AUTO_RECOVERY_INTERVAL = pf.get( QUARTZ_AUTO_RECOVERY_INTERVAL_KEY, int.class ).orElse( 1 ); // h

        // JDBC
        JDBC_PERSIST_BATCH_SIZE = pf.get( JDBC_PERSIST_BATCH_SIZE_KEY, int.class ).orElse( 100 );
        JDBC_QUERY_BATCH_SIZE = pf.get( JDBC_QUERY_BATCH_SIZE_KEY, int.class ).orElse( 250 );
        JDBC_LAZY_BATCH_SIZE = pf.get( JDBC_LAZY_BATCH_SIZE_KEY, int.class ).orElse( 100 );
        JDBC_LAZY_SEQUENCE_BATCH_SIZE = pf.get( JDBC_LAZY_SEQUENCE_BATCH_SIZE_KEY, int.class ).orElse( 1000 );
        JDBC_CONNECTION_POOL_MIN_SIZE = pf.get( JDBC_CONNECTION_POOL_MIN_SIZE_KEY, int.class ).orElse( 1 );
        JDBC_CONNECTION_POOL_MAX_SIZE = pf.get( JDBC_CONNECTION_POOL_MAX_SIZE_KEY, int.class ).orElse( 10 );
        JDBC_READ_ONLY_CONNECTION_POOL_MIN_SIZE = pf.get( JDBC_READ_ONLY_CONNECTION_POOL_MIN_SIZE_KEY, int.class ).orElse( 1 );
        JDBC_READ_ONLY_CONNECTION_POOL_MAX_SIZE = pf.get( JDBC_READ_ONLY_CONNECTION_POOL_MAX_SIZE_KEY, int.class ).orElse( 5 );
        JDBC_CONNECTION_TIMEOUT = pf.get( JDBC_CONNECTION_TIMEOUT_KEY, int.class ).orElse( 30 );
        JDBC_DEFAULT_INSTANCE = pf.get( JDBC_DEFAULT_INSTANCE_KEY, boolean.class ).orElse( false );

        // CACHE
        CACHE_DEFAULT_MAX_TTL = pf.get( CACHE_DEFAULT_MAX_TTL_KEY, int.class ).orElse( 60 ); // m
        CACHE_DEFAULT_MAX_IDLE = pf.get( CACHE_DEFAULT_MAX_IDLE_KEY, int.class ).orElse( 15 ); // m
        CACHE_DEFAULT_MAX_SIZE = pf.get( CACHE_DEFAULT_MAX_SIZE_KEY, int.class ).orElse( 1024 * 4 ); // m
        CACHE_REPLICATED_NEVER_EXPIRE = pf.get( CACHE_REPLICATED_NEVER_EXPIRE_KEY, boolean.class ).orElse( true );
        CACHE_LOCAL_NEVER_EXPIRE = pf.get( CACHE_LOCAL_NEVER_EXPIRE_KEY, boolean.class ).orElse( false );
    }
    public Retry retry(Scheduler scheduler) {
        int numRetries = APP_BACKOFF_RETRY_NUM.get();
        Duration firstBackoff = Duration.ofSeconds( APP_BACKOFF_RETRY_FIRST.get() );
        Duration maxBackoff = Duration.ofSeconds( APP_BACKOFF_RETRY_MAX.get() );
        return Retry.backoff( numRetries, firstBackoff ).maxBackoff( maxBackoff ).scheduler( scheduler );
    }
    public List<String> allowedOrigins() {
        List<URL> allowedOrigins = new LinkedList<>();

        cfg.getStringList( APP_ALLOWED_ORIGINS ).stream().forEach( new Consumer<String>() {
            @Override
            public void accept(String orig) {
                try {
                    allowedOrigins.add( new URL( orig ) );
                }
                catch ( MalformedURLException err ) {
                    throw new RuntimeException( "bad origin", err );
                }
            }
        } );
        return allowedOrigins.stream().map( psi -> {
            String allowedOrigin = psi.getProtocol() + "://" + psi.getHost();
            if ( psi.getPort() > 0 ) {
                allowedOrigin = allowedOrigin + ":" + psi.getPort();
            }
            return allowedOrigin;
        } ).collect( Collectors.toList() );
    }
    public List<String> basicAuth() {
        return cfg.getStringList( APP_BASIC_AUTH );
    }
    public ApplicationConfig cfg() {
        return cfg;
    }

    //
    // TCP
    //
    public final Property<Boolean> TCP_REUSE_ADDRESS;
    public final Property<Boolean> TCP_NODELAY;
    public final Property<Boolean> TCP_KEEP_ALIVE;
    public final Property<Integer> TCP_KEEP_ALIVE_TIMEOUT;
    public final Property<Integer> TCP_CONNECTION_TIMEOUT;
    public final Property<Integer> TCP_SOCKET_TIMEOUT;
    public final Property<Integer> TCP_SOCKET_BACKLOG;
    public final Property<Integer> TCP_MAX_FRAME_SIZE;

    //
    // NETTY
    //
    public final Property<Integer> NETTY_ACCEPTOR_POOL_SIZE;
    public final Property<Integer> NETTY_WORKER_POOL_SIZE;
    //
    // JETTY
    //
    public final Property<Integer> JETTY_POOL_MAX_SIZE;
    public final Property<Integer> JETTY_POOL_MIN_SIZE;
    public final Property<Integer> JETTY_POOL_QUEUE_MAX_SIZE;
    public final Property<Integer> JETTY_POOL_IDLE;
    public final Property<Boolean> JETTY_HTTP_SEND_DATE_HEADER;
    public final Property<Boolean> JETTY_GZIP_ENABLED;
    public final Property<Integer> JETTY_GZIP_MIN_RESPONSE_SIZE;

    //
    // ZK
    //
    public final Property<Integer> ZK_SESSION_TIMEOUT;
    public final Property<Integer> ZK_RETRY_INITIAL;
    public final Property<Integer> ZK_RETRY_MAX;
    //
    // cloud
    //
    public final Property<String> CLOUD_APP_ID;
    public final Property<String> CLOUD_APP_SPACE_NAME;
    public final Property<String> CLOUD_APP_NAME;
    public final Property<String> CLOUD_APP_INSTANCE_INDEX;
    public final Property<String> CLOUD_APP_HOST;
    public final Property<Integer> CLOUD_APP_PORT;

    //
    // APP
    //
    public final Property<Boolean> APP_DEV_MODE;
    public final Property<String> APP_DNS_QUERY;
    public final Property<Integer> APP_BACKOFF_RETRY_FIRST;
    public final Property<Integer> APP_BACKOFF_RETRY_MAX;
    public final Property<Integer> APP_BACKOFF_RETRY_NUM;
    public final Property<Boolean> APP_SENTRY_ENABLED;
    public final Property<Boolean> APP_USE_SELF_SIGNED_CERTIFICATE;
    public final Property<String> APP_LOGGING_RESET_TO;
    public final Property<Boolean> APP_LOGGING_DRY_RUN;
    public final Property<Boolean> APP_METRICS_DRY_RUN;
    public final Property<Boolean> APP_METRICS_ELK_REPORTER_ENABLED;
    public final Property<Boolean> APP_METRICS_INFLUX_REPORTER_ENABLED;
    public final Property<Boolean> APP_METRICS_PROMETHEUS_REPORTER_ENABLED;
    public final Property<Boolean> APP_ALERTS_DRY_RUN;
    public final Property<String> APP_EXTERNAL_IP;
    public final Property<String> APP_JMX_DOMAIN;
    public final Property<String> APP_ALLOWED_ORIGINS;
    public final Property<String> APP_BASIC_AUTH;
    public final Property<Boolean> APP_DB_MIGRATION_ENABLED;
    public final Property<String> APP_DB_MIGRATION_PATH;
    public final Property<Boolean> APP_CONTRACTS_MIGRATION_ENABLED;
    public final Property<Integer> APP_GRACEFUL_SHUTDOWN_TIMEOUNT;
    public final Property<Integer> APP_PLATFORM_POOL_SIZE;
    public final Property<Integer> APP_PLATFORM_MAX_IDLE;
    public final Property<Integer> APP_PLATFORM_GRACEFUL_TIMEOUT;
    public final Property<Integer> APP_TIMER_INTERVAL;
    public final Property<Integer> APP_METRICS_BULK_SIZE;
    public final Property<Double> APP_EXPONENTIAL_BACKOFF;
    public final Property<Integer> APP_REPLICATOR_MAX_RETRIES;
    public final Property<String> APP_REPLICATOR_NAMESPACES;
    public final Property<Integer> APP_REPLICATOR_FETCH_SIZE;
    public final Property<Integer> APP_REPLICATOR_MAX_ATTEMPT_PER_SECOND;
    public final Property<Integer> APP_REPLICATOR_FILES_TTL;
    public final Property<Boolean> APP_REPLICATOR_START_CLEAN;
    public final Property<String> APP_REPLICATION_DIR;
    public final Property<Boolean> APP_HEAP_DUMP_ON_OOM_ENABLED;
    public final Property<String> APP_HEAP_DUMP_DIR;
    public final Property<Boolean> APP_DATA_START_CLEAN;
    public final Property<Integer> APP_WAIT_FOR_HEALTHCHECKS_INTERVAL;
    public final Property<Boolean> APP_WAIT_FOR_HEALTHCHECKS_ENABLED;
    public final Property<Integer> APP_WAIT_FOR_HEALTHCHECKS_TIMEOUT;
    public final Property<Boolean> APP_SHUTDOWN_HOOK_ENABLED;
    public final Property<Boolean> APP_CLEAR_CFG_AT_SHUTDOWN_ENABLED;
    public final Property<Boolean> APP_CFG_DYNAMIC_POLLING_ENABLED;

    //
    // HTTP
    //
    public final Property<Integer> HTTP_POOL_MIN_SIZE;
    public final Property<Integer> HTTP_POOL_MAX_SIZE;

    //
    // REDIS
    //
    public final Property<Integer> REDIS_POOL_MIN_SIZE;
    public final Property<Integer> REDIS_POOL_MAX_SIZE;

    // FLINK
    //
    public final Property<Integer> FLINK_DEFAULT_PARALLELISM;
    public final Property<Boolean> FLINK_CHECKPOINT_ENABLED;
    public final Property<Integer> FLINK_CHECKPOINT_INTERVAL;
    public final Property<Integer> FLINK_CHECKPOINT_TIMEOUT;
    public final Property<Integer> FLINK_CHECKPOINT_MAX_CONCURRENT;
    public final Property<Integer> FLINK_CHECKPOINT_MAX_RESTART_ATTEMPTS;
    public final Property<Integer> FLINK_CHECKPOINT_DELAY_BETWEEN_ATTEMPTS;
    public final Property<String> FLINK_STATE_BACKEND_PATH;

    //
    // KAFKA
    //
    public final Property<Integer> KAFKA_MAX_BLOCK;
    public final Property<Boolean> KAFKA_ENABLED_IDEMPOTENCE;
    public final Property<String> KAFKA_ACKS;
    public final Property<String> KAFKA_COMPRESSION_TYPE;
    public final Property<Integer> KAFKA_MAX_REQUEST_SIZE;
    public final Property<String> KAFKA_AUTO_OFFSET_RESET;
    public final Property<Integer> KAFKA_HEARTBEAT_INTERVAL;
    public final Property<Integer> KAFKA_SESSION_TIMEOUT;
    public final Property<Integer> KAFKA_POLL_MAX_INTERVAL;
    public final Property<Integer> KAFKA_POLL_MAX_RECORDS;
    public final Property<Integer> KAFKA_QUEUE_MAX_SIZE;
    public final Property<Integer> KAFKA_MAX_WORKERS;

    //
    // QUARTZ
    //
    public final Property<String> QUARTZ_SCHEDULER_ID;
    public final Property<Integer> QUARTZ_SCHEDULER_POOL_COUNT;
    public final Property<String> QUARTZ_JOBSTORE_TABLE_PREFIX;
    public final Property<Boolean> QUARTZ_JOBSTORE_USE_PROPS;
    public final Property<Boolean> QUARTZ_JOBSTORE_ACQUIRE_TRIGGERS_WITHIN_LOCK;
    public final Property<Integer> QUARTZ_CONNECTION_POOL_MIN;
    public final Property<Integer> QUARTZ_CONNECTION_POOL_MAX;
    public final Property<Boolean> QUARTZ_JOBSTORE_IS_CLUSTERED;
    public final Property<String> QUARTZ_INSTANCE_ID;
    public final Property<Integer> QUARTZ_AUTO_RECOVERY_INTERVAL;

    //
    // JDBC
    //
    public final Property<Integer> JDBC_PERSIST_BATCH_SIZE;
    public final Property<Integer> JDBC_QUERY_BATCH_SIZE;
    public final Property<Integer> JDBC_LAZY_BATCH_SIZE;
    public final Property<Integer> JDBC_LAZY_SEQUENCE_BATCH_SIZE;
    public final Property<Integer> JDBC_CONNECTION_POOL_MIN_SIZE;
    public final Property<Integer> JDBC_CONNECTION_POOL_MAX_SIZE;
    public final Property<Integer> JDBC_READ_ONLY_CONNECTION_POOL_MIN_SIZE;
    public final Property<Integer> JDBC_READ_ONLY_CONNECTION_POOL_MAX_SIZE;
    public final Property<Integer> JDBC_CONNECTION_TIMEOUT;
    public final Property<Boolean> JDBC_DEFAULT_INSTANCE;

    //
    // CACHE
    //
    public final Property<Integer> CACHE_DEFAULT_MAX_TTL;
    public final Property<Integer> CACHE_DEFAULT_MAX_IDLE;
    public final Property<Integer> CACHE_DEFAULT_MAX_SIZE;
    public final Property<Boolean> CACHE_REPLICATED_NEVER_EXPIRE;
    public final Property<Boolean> CACHE_LOCAL_NEVER_EXPIRE;

    private final ApplicationConfig cfg;
}
