package com.turbospaces.support;

import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;

import com.turbospaces.boot.AbstractBootstrapAware;

import io.micrometer.core.aop.TimedAspect;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass = true)
public class TimedConfiguration extends AbstractBootstrapAware {
    @Bean
    public TimedAspect timedAspect() {
        return new TimedAspect(bootstrap.meterRegistry());
    }
}
