package com.turbospaces.rpc;

import java.time.Duration;
import java.util.function.Supplier;

import org.apache.commons.lang3.StringUtils;
import org.springframework.util.concurrent.ListenableFuture;

import com.google.protobuf.Message;
import com.turbospaces.api.facade.NotificationWrapperFacade;
import com.turbospaces.dispatch.EventQueuePostSpec;
import com.turbospaces.dispatch.NotifyQueuePostSpec;
import com.turbospaces.dispatch.RequestQueuePostSpec;

import io.netty.util.AsciiString;

public interface QueuePostTemplate<C> extends QueueOutcomePublisher<C>, EventQueuePostTemplate<C>, NotifyQueuePostTemplate<C> {
    default WrappedQueuePost sendReq(String destination, String replyTo, Message payload) {
        RequestQueuePostSpec.RequestBuilder spec = RequestQueuePostSpec.newBuilder(payload);
        spec.setTopic(destination);
        spec.setReplyTo(replyTo);

        return sendReq(spec.build());
    }
    default WrappedQueuePost sendReq(String destination, String replyTo, Message payload, AsciiString routingKey) {
        RequestQueuePostSpec.RequestBuilder spec = RequestQueuePostSpec.newBuilder(payload);
        spec.setTopic(destination);
        spec.setReplyTo(replyTo);
        if (StringUtils.isNotEmpty(routingKey)) {
            spec.setRoutingKey(routingKey);
        }

        return sendReq(spec.build());
    }
    default WrappedQueuePost sendReq(String destination, String replyTo, Message payload, AsciiString routingKey, Supplier<Duration> timeout) {
        RequestQueuePostSpec.RequestBuilder spec = RequestQueuePostSpec.newBuilder(payload, timeout.get());
        spec.setTopic(destination);
        spec.setReplyTo(replyTo);
        if (StringUtils.isNotEmpty(routingKey)) {
            spec.setRoutingKey(routingKey);
        }

        return sendReq(spec.build());
    }
    default ListenableFuture<C> sendEvent(String destination, Message payload) {
        EventQueuePostSpec.EventBuilder spec = EventQueuePostSpec.newBuilder(payload);
        spec.setTopic(destination);

        return sendEvent(spec.build());
    }
    default ListenableFuture<C> sendEvent(String destination, Message payload, AsciiString routingKey) {
        EventQueuePostSpec.EventBuilder spec = EventQueuePostSpec.newBuilder(payload);
        spec.setTopic(destination);
        if (StringUtils.isNotEmpty(routingKey)) {
            spec.setRoutingKey(routingKey);
        }

        return sendEvent(spec.build());
    }
    default ListenableFuture<C> sendNotify(String destination, NotificationWrapperFacade payload) {
        NotifyQueuePostSpec.NotificationBuilder spec = NotifyQueuePostSpec.newBuilder(payload);
        spec.setTopic(destination);

        return sendNotify(spec.build());
    }
    default ListenableFuture<C> sendNotify(String destination, NotificationWrapperFacade payload, AsciiString routingKey) {
        NotifyQueuePostSpec.NotificationBuilder spec = NotifyQueuePostSpec.newBuilder(payload);
        spec.setTopic(destination);
        if (StringUtils.isNotEmpty(routingKey)) {
            spec.setRoutingKey(routingKey);
        }

        return sendNotify(spec.build());
    }
}
