package com.turbospaces.rpc;

import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.TimeoutException;

import lombok.Getter;

@SuppressWarnings("serial")
@Getter
public class RequestReplyTimeout extends TimeoutException {
    private final Duration duration;
    private final Object key;

    public RequestReplyTimeout(Duration duration, Object key) {
        super(String.format("no response in %d sec(s) for %s", duration.toSeconds(), key));
        this.duration = Objects.requireNonNull(duration);
        this.key = Objects.requireNonNull(key);
    }
}
