package com.turbospaces.rpc;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;

import api.facade.ResponseStatusFacade;
import api.v1.ResponseWrapperFacade;
import lombok.AllArgsConstructor;

@AllArgsConstructor
public class DefaultApiResponseEntity<T extends Message> implements ApiResponseEntity<T> {
    private final ResponseWrapperFacade wrapper;
    private final Class<T> type;

    @Override
    public ResponseStatusFacade status() {
        return wrapper.status();
    }
    @Override
    public T body() throws InvalidProtocolBufferException {
        return wrapper.unpack(type);
    }
}
