package com.turbospaces.rpc;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;

import api.facade.ResponseStatusFacade;
import api.v1.ApplicationException;
import api.v1.ReplyUtil;

public interface ApiResponseEntity<T extends Message> {
    ResponseStatusFacade status();
    T body() throws InvalidProtocolBufferException;

    default void verifyOk() throws ApplicationException {
        ReplyUtil.verifyOk(status());
    }
    default T getBodyAndVerifyOk() throws ApplicationException, InvalidProtocolBufferException {
        verifyOk();
        return body();
    }
}
