package com.turbospaces.rpc;

import java.util.concurrent.Executor;
import java.util.function.Consumer;

import org.slf4j.Logger;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.turbospaces.common.NonBlockingCallOnly;

import api.facade.HeadersFacade;
import api.facade.ResponseStatusFacade;
import api.v1.ResponseWrapperFacade;
import io.opentracing.Span;

public interface ApiResponse<RESP extends Message> extends ListenableFuture<ApiResponseEntity<RESP>> {
    HeadersFacade headers();
    Any request();
    Span span();
    ResponseWrapperFacade toReply(Message message, ResponseStatusFacade status);
    ResponseWrapperFacade toExceptionalReply(Message message, Exception exception);

    @Override
    void addListener(Runnable listener, Executor executor);
    void addCallback(FutureCallback<ApiResponseEntity<RESP>> callback, Executor executor);
    ApiResponse<RESP> thenVerifyOk(Executor executor);
    ApiResponse<RESP> thenVerifyOkAndAccept(Consumer<RESP> callback, Executor executor);

    default void addListener(Runnable listener) {
        addListener(listener, MoreExecutors.directExecutor());
    }
    default void addCallback(FutureCallback<ApiResponseEntity<RESP>> callback) {
        addCallback(callback, MoreExecutors.directExecutor());
    }
    default ApiResponse<RESP> thenVerifyOk() {
        return thenVerifyOk(MoreExecutors.directExecutor());
    }
    default ApiResponse<RESP> thenVerifyOkAndAccept(Consumer<RESP> callback) {
        return thenVerifyOkAndAccept(callback, MoreExecutors.directExecutor());
    }
    default void runGuard(String serviceName, Logger log) {
        if (!isDone() && NonBlockingCallOnly.MARKER.get()) {
            log.error("api abuse detected: blocking remote call on service {}", serviceName);
        }
    }
}
