package com.turbospaces.dispatch;

import java.time.LocalDate;
import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.BooleanUtils;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Message;
import com.google.protobuf.Message.Builder;
import com.turbospaces.executor.WorkUnit;

import api.facade.RequestWrapperFacade;
import io.netty.util.AsciiString;

public interface TransactionalRequest<REQ extends Message, RESP extends Message.Builder> {
    RequestWrapperFacade wrapper();
    REQ request() throws Exception;
    RESP reply();
    Date timestamp();
    LocalDate at();
    AsciiString routingKey();
    void setRoutingKey(AsciiString hash);
    WorkUnit record();

    String addMetricTag(String k, String v);
    Map<String, String> tags();

    boolean ack();
    boolean nack();
    boolean isAcked();
    boolean isNacked();
    default boolean isAckOrNack() {
        return BooleanUtils.or(new boolean[] { isAcked(), isNacked() });
    }

    void preserveReply();
    void preserveNotifications();
    void preserveEventStream();
    boolean isPreserveReply();
    boolean isPreserveNotifications();
    boolean isPreserveEventStream();

    ListenableFuture<?> replyCondition();
    void replyWhen(ListenableFuture<?> task);

    <T extends Builder> T notify(T msg);
    <T extends Builder> T eventStream(T msg);

    List<Message.Builder> notifications();
    List<Message.Builder> eventStreaming();

    void clear();
    String jdbcOp(String... args);
}
