package com.turbospaces.rpc;

import java.util.concurrent.Executor;
import java.util.function.Consumer;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;

import api.v1.RequestWrapperFacade;
import api.v1.ResponseWrapperFacade;
import io.opentracing.Span;

public interface WrappedQueuePost extends ListenableFuture<ResponseWrapperFacade> {
    Span span();
    RequestWrapperFacade requestWrapper();

    @Override
    void addListener(Runnable listener, Executor executor);
    void addCallback(FutureCallback<ResponseWrapperFacade> callback, Executor executor);

    WrappedQueuePost thenVerifyOk(Executor executor);
    WrappedQueuePost thenVerifyOkAndAccept(Consumer<ResponseWrapperFacade> callback, Executor executor);

    default void addListener(Runnable listener) {
        addListener(listener, MoreExecutors.directExecutor());
    }
    default void addCallback(FutureCallback<ResponseWrapperFacade> callback) {
        addCallback(callback, MoreExecutors.directExecutor());
    }
    default WrappedQueuePost thenVerifyOk() {
        return thenVerifyOk(MoreExecutors.directExecutor());
    }
    default WrappedQueuePost thenVerifyOkAndAccept(Consumer<ResponseWrapperFacade> callback) {
        return thenVerifyOkAndAccept(callback, MoreExecutors.directExecutor());
    }
}
