package com.turbospaces.rpc;

import java.time.Duration;

import com.google.common.util.concurrent.SettableFuture;

public interface RequestReplyMapper<K, V> {
    SettableFuture<V> acquire(K corrId, Duration duration);
    void complete(K corrId, V value);
    boolean contains(K corrId);
    void completeExceptionally(K corrId, Throwable reason);
    void clear();
    int pendingCount();
}
