package com.turbospaces.rpc;

import java.time.Duration;
import java.util.function.Supplier;

import org.springframework.util.concurrent.ListenableFutureCallback;

import com.google.protobuf.Message;
import com.turbospaces.dispatch.QueuePostSpec;

import io.netty.util.AsciiString;
import io.opentracing.Span;

public interface QueuePostTemplate<C> {
    WrappedQueuePost send(QueuePostSpec<C> spec);
    WrappedQueuePost send(String destination, String replyTo, Message payload, AsciiString routingKey);
    WrappedQueuePost send(String destination, String replyTo, Message payload, AsciiString routingKey, Supplier<Duration> timeout);
    WrappedQueuePost send(String destination, Span parentSpan, String replyTo, Message payload, AsciiString routingKey, Supplier<Duration> timeout);

    void sendOneWay(QueuePostSpec<C> spec);
    void sendOneWay(String destination, Message payload, AsciiString routingKey);
    void sendOneWay(String destination, Message payload, AsciiString routingKey, ListenableFutureCallback<C> callback);
}
