package com.turbospaces.executor;

import java.util.Objects;
import java.util.function.Consumer;

import io.netty.util.AsciiString;

public interface WorkUnit {
    long timestamp();
    String topic();
    byte[] key();

    default WorkUnit ifKeyPresent(Consumer<AsciiString> consumer) {
        if (Objects.nonNull(key())) {
            consumer.accept(new AsciiString(key()));
        }
        return this;
    }
}
