package common.kafka;

import java.util.List;

import com.google.common.collect.Lists;
import com.google.protobuf.Any;
import com.google.protobuf.Message;
import com.google.protobuf.TextFormat;
import com.turbospaces.handlers.QueuePostSpec;

import io.netty.util.AsciiString;
import lombok.Builder;
import lombok.Getter;

@Getter
@Builder
public class TransactionalRequestOutcome<R extends Message, N extends Message> {
    private final AsciiString key;

    private final R reply;

    @Builder.Default
    private final List<N> notifications = Lists.newLinkedList();

    @Builder.Default
    private final List<Any> eventStream = Lists.newLinkedList();

    @Builder.Default
    private final List<QueuePostSpec<?>> generic = Lists.newLinkedList();

    @Override
    public String toString() {
        return TextFormat.printer().shortDebugString(getReply());
    }
}
