package common.kafka;

import java.util.concurrent.CountDownLatch;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.Message;
import com.turbospaces.executor.WorkUnit;

public interface ServiceCallAsyncDispatcher<REQW extends Message, RESP extends Message, NOTIFY extends Message> {
    ListenableFuture<TransactionalRequestOutcome<RESP, NOTIFY>> schedule(WorkUnit unit, REQW reqw, CountDownLatch latch) throws Exception;
}
