package com.turbospaces.http;

public interface HttpProto {
    String PARAM_PROXY_REF = "_pref";

    //
    // ~ pretty print HTTP wire
    //
    String CONTEXT_REQ_PRINTER = "req-printer";
    String CONTEXT_RESPONSE_PRINTER = "response-printer";
    String CONTEXT_RESPONSE_DO_NOT_PRINT_BODY = "response-do-not-print-body";
    String CONTEXT_MATCHED = "matched";
    String CONTEXT_STARTED_AT = "started-at";
    String CONTEXT_URI = "uri";

    String V1 = "/v1";
    String V2 = "/v2";
    String V3 = "/v3";

    //
    // ~ system preserved path(s)
    //
    String VERSION_PATH = "/version";
    String IP_PATH = "/ip";
    String HEALTHCHECK_PATH = "/health_check";
    String THREAD_DUMP_PATH = "/thread_dump";
    String METRICS_PATH = "/metrics";

    //
    // ~ CloudFlare preserved header(s)
    //
    String HEADER_CF_IP_COUNTRY = "CF-IPCountry";
    String HEADER_CF_CONNECTING_IP = "CF-Connecting-IP";
    String HEADER_CF_BOT_SCORE = "CF-Bot-Score";

    //
    // ~ common application headers
    //
    String HEADER_TRACE_ID = "X-Trace-ID";
    String HEADER_X_PLATFORM = "X-Platform";
    String HEADER_X_TIMESTAMP = "X-Timestamp";
    String HEADER_X_CHK = "X-Chk";
    String HEADER_X_REASON = "X-Reason";
    String HEADER_X_USER_AGENT = "X-User-Agent";

    //
    // ~ widely used HMAC symmetric cryptography query parameters (UPS query part)
    //
    String QUERY_PARAM_HMAC_ALG = "hmacAlg";
    String QUERY_PARAM_HMAC_METHOD = "hmacMethod";
    String QUERY_PARAM_HMAC_KEY = "hmacKey";

    static String toCtxName(String prop) {
        return String.format("%s.%s", HttpProto.class.getSimpleName(), prop);
    }
}
