package com.turbospaces.executor;

import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor.CallerRunsPolicy;

import lombok.extern.slf4j.Slf4j;

@Slf4j
public class LogQueueFullCallerRunsPolicy extends CallerRunsPolicy {
    @Override
    public void rejectedExecution(Runnable r, ThreadPoolExecutor e) {
        log.error("task: {} will be executed in current thread because {} has no resources to run it", r, e);
        super.rejectedExecution(r, e);
    }
}
