package com.turbospaces.executor;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.turbospaces.boot.PlatformExecutorService;

import io.vavr.CheckedFunction0;
import io.vavr.CheckedRunnable;

public class DirectPlatformExecutorService implements PlatformExecutorService {
    @Override
    public void execute(Runnable command) {
        MoreExecutors.directExecutor().execute(command);
    }
    @Override
    public ListenableFuture<?> submit(CheckedRunnable action) {
        SettableFuture<Object> settable = SettableFuture.create();

        try {
            MoreExecutors.directExecutor().execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        action.run();
                        settable.set(new Object());
                    } catch (Throwable err) {
                        settable.setException(err);
                    }
                }
            });
        } catch (Throwable err) {
            settable.setException(err);
        }

        return settable;
    }

    @Override
    public <T> ListenableFuture<T> submit(CheckedFunction0<T> action) {
        SettableFuture<T> settable = SettableFuture.create();

        try {
            MoreExecutors.directExecutor().execute(new Runnable() {
                @Override
                public void run() {
                    try {
                        settable.set(action.apply());
                    } catch (Throwable err) {
                        settable.setException(err);
                    }
                }
            });
        } catch (Throwable err) {
            settable.setException(err);
        }

        return settable;
    }
}