package com.turbospaces.executor;

import java.util.Objects;

import com.turbospaces.boot.PlatformExecutorService;

public interface ContextWorker extends PlatformExecutorService {
    ContextWorker forKey(WorkUnit unit);

    default ContextWorker ifPresent(WorkUnit unit) {
        if (Objects.nonNull(unit.key())) {
            return actor(unit);
        }
        return this;
    }
    default ContextWorker actor(WorkUnit unit) {
        return forKey(unit);
    }
}
