package com.turbospaces.common;

import java.util.concurrent.TimeUnit;

import com.codahale.metrics.MetricFilter;
import com.codahale.metrics.json.HealthCheckModule;
import com.codahale.metrics.json.MetricsModule;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.util.StdDateFormat;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.github.robtimus.obfuscation.jackson.databind.ObfuscationModule;

@SuppressWarnings("serial")
public class CommonObjectMapper extends BasicObjectMapper {
    public CommonObjectMapper(JsonMapper jsonMapper) {
        super(jsonMapper);
    }
    public CommonObjectMapper() {
        super();

        registerModule(new JsonOrgModule());
        registerModule(new JavaTimeModule());
        registerModule(new GuavaModule());

        //
        // ~ obfuscation
        //
        registerModule(ObfuscationModule.defaultModule());

        //
        // ~ metrics
        //
        registerModule(new HealthCheckModule());
        registerModule(new MetricsModule(TimeUnit.SECONDS, TimeUnit.MILLISECONDS, true, MetricFilter.ALL));

        //
        // ~ date format
        //
        setDateFormat(new StdDateFormat().withColonInTimeZone(true));
    }
    @Override
    public CommonObjectMapper copy() {
        this._checkInvalidCopy(CommonObjectMapper.class);
        return new CommonObjectMapper(this);
    }
}
