package com.turbospaces.common;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;

public interface RequestReplyMapper<K, V> {
    CompletableFuture<V> acquire(K corrId, int timeout, TimeUnit unit);
    void complete(K corrId, V value);
    void completeExceptionally(K corrId, Throwable reason);
    void completeExceptionally(Throwable reason);
    void clear();
    int pendingCount();
}
