/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.executor;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListenableScheduledFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.turbospaces.boot.AbstractBootstrapAware;
import com.turbospaces.boot.PlatformScheduledExecutorService;
import com.turbospaces.common.PlatformUtil;
import com.turbospaces.executor.LogQueueFullCallerRunsPolicy;
import io.micrometer.core.instrument.binder.jvm.ExecutorServiceMetrics;
import java.time.Duration;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.MDC;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class GlobalPlatformScheduledExecutorService
extends AbstractBootstrapAware
implements PlatformScheduledExecutorService,
InitializingBean,
DisposableBean {
    private ListeningScheduledExecutorService executor;

    public void afterPropertiesSet() {
        int size = (Integer)this.bootstrap.props().APP_PLATFORM_POOL_SIZE.get();
        ThreadFactoryBuilder factory = new ThreadFactoryBuilder();
        factory.setDaemon(false);
        factory.setNameFormat("global-worker-%d");
        ScheduledThreadPoolExecutor pool = new ScheduledThreadPoolExecutor(size, factory.build(), new LogQueueFullCallerRunsPolicy());
        this.executor = MoreExecutors.listeningDecorator((ScheduledExecutorService)pool);
        ExecutorServiceMetrics metrics = new ExecutorServiceMetrics((ExecutorService)pool, "platform", Collections.emptyList());
        metrics.bindTo(this.bootstrap.meterRegistry());
    }

    public void destroy() {
        StopWatch stopWatch = StopWatch.createStarted();
        Duration timeout = (Duration)this.bootstrap.props().APP_PLATFORM_GRACEFUL_SHUTDOWN_TIMEOUT.get();
        PlatformUtil.shutdownExecutor((ExecutorService)this.executor, timeout);
        stopWatch.stop();
        this.logger.debug("stopped global scheduled-executor-service: {} in {}", (Object)this.executor, (Object)stopWatch);
    }

    @Override
    public void execute(Runnable command) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        this.executor.execute(this.wrapRunnable(command, mdcContextMap));
    }

    public ListenableFuture<?> submit(Runnable task) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        return this.executor.submit(this.wrapRunnable(task, mdcContextMap));
    }

    public <T> ListenableFuture<T> submit(Callable<T> task) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        return this.executor.submit(this.wrapCallable(task, mdcContextMap));
    }

    public <T> ListenableFuture<T> submit(Runnable task, T result) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        return this.executor.submit(this.wrapRunnable(task, mdcContextMap), result);
    }

    public ListenableScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        return this.executor.schedule(this.wrapRunnable(command, mdcContextMap), delay, unit);
    }

    public ListenableScheduledFuture<?> schedule(Runnable command, Duration delay) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        return this.executor.schedule(this.wrapRunnable(command, mdcContextMap), delay);
    }

    public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, Duration delay) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        return this.executor.schedule(this.wrapCallable(callable, mdcContextMap), delay);
    }

    public <V> ListenableScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        return this.executor.schedule(this.wrapCallable(callable, mdcContextMap), delay, unit);
    }

    public ListenableScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(command, initialDelay, period, unit);
    }

    public ListenableScheduledFuture<?> scheduleWithFixedDelay(Runnable command, Duration initialDelay, Duration delay) {
        return this.executor.scheduleWithFixedDelay(command, initialDelay, delay);
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(command, initialDelay, delay, unit);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }

    @Override
    public List<Runnable> shutdownNow() {
        return this.executor.shutdownNow();
    }

    @Override
    public boolean isShutdown() {
        return this.executor.isShutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.executor.isTerminated();
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.awaitTermination(timeout, unit);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) throws InterruptedException {
        return this.executor.invokeAll(tasks);
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException {
        return this.executor.invokeAll(tasks, timeout, unit);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws InterruptedException, ExecutionException {
        return (T)this.executor.invokeAny(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.executor.invokeAny(tasks, timeout, unit);
    }
}

