/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.cfg;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import com.netflix.archaius.DefaultDecoder;
import com.netflix.archaius.api.Decoder;
import com.netflix.archaius.api.TypeConverter;
import com.netflix.archaius.api.config.SettableConfig;
import com.netflix.archaius.api.exceptions.ConfigException;
import com.netflix.archaius.config.DefaultCompositeConfig;
import com.netflix.archaius.config.DefaultSettableConfig;
import com.netflix.archaius.config.EmptyConfig;
import com.netflix.archaius.config.MapConfig;
import com.netflix.archaius.config.SystemConfig;
import com.turbospaces.cfg.DynamicCompositeConfig;
import com.turbospaces.cfg.DynamicPropertyFactory;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigSyntax;
import com.typesafe.config.ConfigValue;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.net.URL;
import java.time.Duration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.ResourceUtils;

public class ApplicationConfig
extends DefaultCompositeConfig
implements DynamicCompositeConfig {
    private static final Logger log = LoggerFactory.getLogger(ApplicationConfig.class);
    private final DynamicPropertyFactory propertyFactory;

    public ApplicationConfig(Duration refreshInterval) throws ConfigException {
        LinkedList<String> ignorePattern = new LinkedList<String>();
        ignorePattern.add("UPS_");
        ignorePattern.add("SPACE_NAME");
        ignorePattern.add("HOSTNAME");
        HashMap<String, String> oldgetenv = new HashMap<String, String>(System.getenv());
        HashMap<String, String> newgetenv = new HashMap<String, String>();
        for (Map.Entry it : oldgetenv.entrySet()) {
            String oldProp = (String)it.getKey();
            String newProp = oldProp.toLowerCase().replaceAll("_", ".");
            boolean allowed = true;
            for (String s : ignorePattern) {
                if (!oldProp.startsWith(s)) continue;
                allowed = false;
                break;
            }
            if (!allowed) continue;
            log.trace("adding ENV prop {}={}", new Object[]{oldProp, newProp, it.getValue()});
            newgetenv.put(newProp, (String)it.getValue());
        }
        this.addConfig("core.RUNTIME_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
        this.addConfig("core.LOCAL_APPLICATION_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
        this.addConfig("core.CLOUD_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
        this.addConfig("core.CMD_LINE_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
        this.addConfig("core.ENV_PROPS_CFG", (com.netflix.archaius.api.Config)new MapConfig(newgetenv));
        this.addConfig("core.SYSTEM_PROPS_CFG", (com.netflix.archaius.api.Config)new SystemConfig());
        this.addConfig("core.GIT_CFG", (com.netflix.archaius.api.Config)new DefaultCompositeConfig());
        this.addConfig("core.LEGACY_CFG", (com.netflix.archaius.api.Config)EmptyConfig.INSTANCE);
        this.addConfig("core.DEFAULT_APP_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
        this.addBuildMetaConfig(new DefaultSettableConfig());
        this.propertyFactory = DynamicPropertyFactory.from((com.netflix.archaius.api.Config)this);
        try {
            this.setDecoder((Decoder)ApplicationConfig.decoder());
        }
        catch (IllegalAccessException | IllegalArgumentException err) {
            throw new ConfigException(err.getMessage(), (Throwable)err);
        }
    }

    @Override
    public DynamicPropertyFactory factory() {
        return this.propertyFactory;
    }

    @Override
    public void clearLocalProperty(String key) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.LOCAL_APPLICATION_CFG");
        c.clearProperty(key);
        log.info("clearing local prop: {}", (Object)key);
    }

    @Override
    public void setLocalProperty(String key, Object value) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.LOCAL_APPLICATION_CFG");
        c.setProperty(key, value);
        log.info("setting local prop: {} -> {}", (Object)key, value);
    }

    @Override
    public void setLocalProperties(Properties props) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.LOCAL_APPLICATION_CFG");
        c.setProperties(props);
        log.info("setting local props: {}", (Object)props);
    }

    @Override
    public void clearCmdLineParams(String key) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.CMD_LINE_CFG");
        c.clearProperty(key);
        log.info("clearing command line prop: {}", (Object)key);
    }

    @Override
    public void setCmdLineParams(String key, Object value) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.CMD_LINE_CFG");
        c.setProperty(key, value);
        log.info("setting command line prop: {} -> {}", (Object)key, value);
    }

    @Override
    public void setCmdLineParams(Properties props) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.CMD_LINE_CFG");
        c.setProperties(props);
        log.info("setting command line props: {}", (Object)props);
    }

    @Override
    public void clearDefaultProperty(String key) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.DEFAULT_APP_CFG");
        c.clearProperty(key);
        log.info("clearing default prop: {}", (Object)key);
    }

    @Override
    public void setDefaultProperty(String key, Object value) {
        SettableConfig c = (SettableConfig)this.getConfig("core.DEFAULT_APP_CFG");
        c.setProperty(key, value);
        log.info("setting default prop: {} -> {}", (Object)key, value);
    }

    @Override
    public void setDefaultProperties(Properties props) {
        DefaultSettableConfig c = (DefaultSettableConfig)this.getConfig("core.DEFAULT_APP_CFG");
        c.setProperties(props);
        log.info("setting default props: {}", (Object)props);
    }

    @Override
    public void clearAllDefaultProperties() throws ConfigException {
        log.info("clearing default cfg: {}", (Object)ImmutableList.copyOf((Iterator)this.getConfig("core.DEFAULT_APP_CFG").getKeys()));
        this.replaceConfig("core.DEFAULT_APP_CFG", (com.netflix.archaius.api.Config)new DefaultSettableConfig());
    }

    @Override
    public ApplicationConfig loadLocalDevProperties(String username) throws Exception {
        for (String pattern : new String[]{"template", username}) {
            String userOverrideProps = String.format("classpath:local-dev-%s.properties", pattern);
            String userOverrideCfg = String.format("classpath:local-dev-%s.conf", pattern);
            URL propsURL = null;
            URL cfgURL = null;
            try {
                propsURL = ResourceUtils.getURL((String)userOverrideProps);
            }
            catch (FileNotFoundException err) {
                log.trace(err.getMessage(), (Throwable)err);
            }
            try {
                cfgURL = ResourceUtils.getURL((String)userOverrideCfg);
            }
            catch (FileNotFoundException err) {
                log.trace(err.getMessage(), (Throwable)err);
            }
            if (propsURL != null) {
                try (InputStream io = propsURL.openStream();){
                    Properties tmp = new Properties();
                    tmp.load(io);
                    this.setLocalProperties(tmp);
                }
            }
            if (cfgURL == null) continue;
            File file = new File(cfgURL.toURI());
            ConfigParseOptions parseOptions = ConfigParseOptions.defaults().setAllowMissing(false).setSyntax(ConfigSyntax.CONF);
            Config typesafeConfig = ConfigFactory.parseFile((File)file, (ConfigParseOptions)parseOptions).resolve();
            for (Map.Entry entry : typesafeConfig.entrySet()) {
                String key = (String)entry.getKey();
                Object value = ((ConfigValue)entry.getValue()).unwrapped();
                if (Objects.isNull(value)) {
                    this.clearLocalProperty(key);
                    continue;
                }
                if (value instanceof List) {
                    List list = (List)value;
                    this.setLocalProperty(key, Joiner.on((String)this.getListDelimiter()).join((Iterable)list));
                    continue;
                }
                if (value instanceof Set) {
                    Set set = (Set)value;
                    this.setLocalProperty(key, Joiner.on((String)this.getListDelimiter()).join((Iterable)set));
                    continue;
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    StringBuilder builer = new StringBuilder();
                    Iterator it = map.entrySet().iterator();
                    while (it.hasNext()) {
                        Map.Entry next = it.next();
                        builer.append(next.toString() + "=" + next.toString());
                        if (!it.hasNext()) continue;
                        builer.append(this.getListDelimiter());
                    }
                    this.setLocalProperty(key, builer);
                    continue;
                }
                if (Primitives.allWrapperTypes().contains(value.getClass())) {
                    this.setLocalProperty(key, value);
                    continue;
                }
                this.setLocalProperty(key, value);
            }
        }
        return this;
    }

    @Override
    public ApplicationConfig loadDefaultPropsFromResource(URL resource) throws IOException {
        try (InputStream io = resource.openStream();){
            Properties props = new Properties();
            props.load(io);
            this.setDefaultProperties(props);
        }
        return this;
    }

    @Override
    public ApplicationConfig loadLocalDevProperties() throws Exception {
        String username = System.getProperty("user.name");
        this.loadLocalDevProperties(username);
        return this;
    }

    private void addBuildMetaConfig(DefaultSettableConfig cfg) throws ConfigException {
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream("git.properties");){
            if (is != null) {
                this.addConfig("core.BUILD_META_CFG", (com.netflix.archaius.api.Config)cfg);
                Properties props = new Properties();
                props.load(is);
                cfg.setProperties(props);
            }
        }
        catch (IOException e) {
            log.error("Can't load git build properties", (Throwable)e);
        }
    }

    private static DefaultDecoder decoder() throws IllegalArgumentException, IllegalAccessException {
        DefaultDecoder decoder = DefaultDecoder.INSTANCE;
        log.info("attempting to patch default codec: {}", (Object)decoder);
        Field f = ReflectionUtils.findField(DefaultDecoder.class, (String)"factories");
        f.setAccessible(true);
        List factories = (List)f.get(decoder);
        factories.add(new TypeConverter.Factory(){

            public Optional<TypeConverter<?>> get(Type type, TypeConverter.Registry registry) {
                if (type.equals(Pattern.class)) {
                    return Optional.of(Pattern::compile);
                }
                return Optional.empty();
            }
        });
        return decoder;
    }

    public static ApplicationConfig create() throws ConfigException {
        return ApplicationConfig.create(Duration.ofSeconds(15L));
    }

    public static ApplicationConfig create(Duration refreshInterval) throws ConfigException {
        return new ApplicationConfig(refreshInterval);
    }

    public static ApplicationConfig create(String appId, Duration refreshInterval) throws ConfigException {
        ApplicationConfig cfg = ApplicationConfig.create();
        cfg.setDefaultProperty("cloud.application.app-id", appId);
        return cfg;
    }
}

