/*
 * Decompiled with CFR 0.152.
 */
package com.turbospaces.boot;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import com.turbospaces.common.MDCUtil;
import com.turbospaces.executor.DirectPlatformExecutorService;
import io.vavr.CheckedFunction0;
import io.vavr.CheckedRunnable;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.slf4j.MDC;

public interface PlatformExecutorService
extends Executor {
    public static final PlatformExecutorService DIRECT_EXECUTOR = new DirectPlatformExecutorService();

    default public ListenableFuture<?> submit(final CheckedRunnable action) {
        final SettableFuture settable = SettableFuture.create();
        try {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        action.run();
                        settable.set(new Object());
                    }
                    catch (Throwable err) {
                        settable.setException(err);
                    }
                }
            });
        }
        catch (RejectedExecutionException err) {
            settable.setException((Throwable)err);
        }
        return settable;
    }

    default public <T> ListenableFuture<T> submit(final CheckedFunction0<T> action) {
        final SettableFuture settable = SettableFuture.create();
        try {
            this.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        settable.set(action.apply());
                    }
                    catch (Throwable err) {
                        settable.setException(err);
                    }
                }
            });
        }
        catch (RejectedExecutionException err) {
            settable.setException((Throwable)err);
        }
        return settable;
    }

    default public Runnable wrapRunnable(final Runnable task, final Map<String, String> mdcContextMap) {
        return new Runnable(){

            @Override
            public void run() {
                MDCUtil.propagete(mdcContextMap);
                try {
                    task.run();
                }
                finally {
                    MDC.clear();
                }
            }
        };
    }

    default public <V> Callable<V> wrapCallable(final Callable<V> task, final Map<String, String> mdcContextMap) {
        return new Callable<V>(){

            @Override
            public V call() throws Exception {
                MDCUtil.propagete(mdcContextMap);
                try {
                    Object v = task.call();
                    return v;
                }
                finally {
                    MDC.clear();
                }
            }
        };
    }
}

